/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.SouthFace;
import net.malisis.core.renderer.font.CharData;
import net.malisis.core.renderer.font.FontGenerator;
import net.malisis.core.renderer.font.FontGeneratorOptions;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MinecraftFont;
import net.malisis.core.renderer.font.StringWalker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class MalisisFont {
    public static String CHARLIST = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    private static Pattern pattern = Pattern.compile("\\{(.*?)}");
    public static MalisisFont minecraftFont = new MinecraftFont();
    protected Font font;
    protected FontRenderContext frc;
    protected FontGeneratorOptions fontGeneratorOptions = FontGeneratorOptions.DEFAULT;
    protected CharData[] charData = new CharData[256];
    protected ResourceLocation textureRl;
    protected int size;
    protected boolean drawingShadow = false;
    protected float zIndex = 0.0f;

    public MalisisFont(File fontFile) {
        this(MalisisFont.load(fontFile, FontGeneratorOptions.DEFAULT), null);
    }

    public MalisisFont(File fontFile, FontGeneratorOptions options) {
        this(MalisisFont.load(fontFile, options), options);
    }

    public MalisisFont(ResourceLocation fontFile) {
        this(MalisisFont.load(fontFile, FontGeneratorOptions.DEFAULT), null);
    }

    public MalisisFont(ResourceLocation fontFile, FontGeneratorOptions options) {
        this(MalisisFont.load(fontFile, options), options);
    }

    public MalisisFont(Font font) {
        this(font, null);
    }

    public MalisisFont(Font font, FontGeneratorOptions options) {
        this.font = font;
        if (font == null) {
            return;
        }
        if (options != null) {
            this.fontGeneratorOptions = options;
        }
        this.loadCharacterData();
        this.loadTexture(false);
    }

    public ResourceLocation getResourceLocation() {
        return this.textureRl;
    }

    public void generateTexture(boolean debug) {
        this.fontGeneratorOptions.debug = debug;
        this.loadCharacterData();
        this.loadTexture(true);
    }

    public CharData getCharData(char c) {
        if (c < '\u0000' || c > this.charData.length) {
            c = (char)63;
        }
        return this.charData[c];
    }

    public Shape getShape(String text, float fontSize) {
        text = this.processString(text, null);
        ArrayList<Face> faces = new ArrayList<Face>();
        float offset = 0.0f;
        float factor = this.fontGeneratorOptions.fontSize / fontSize;
        for (int i = 0; i < text.length(); ++i) {
            CharData cd = this.getCharData(text.charAt(i));
            if (cd.getChar() != ' ') {
                SouthFace f = new SouthFace();
                f.scale(cd.getFullWidth(this.fontGeneratorOptions) / factor, cd.getFullHeight(this.fontGeneratorOptions) / factor, 0.0f);
                f.translate((offset - this.fontGeneratorOptions.mx) / factor, -this.fontGeneratorOptions.my / factor, 0.0f);
                f.setTexture(cd.getIcon());
                faces.add(f);
            }
            offset += cd.getCharWidth();
        }
        return new Shape(faces).storeState();
    }

    protected void prepare(MalisisRenderer<?> renderer, float x, float y, float z, FontOptions options) {
        boolean isGui = renderer instanceof GuiRenderer;
        renderer.next(7, DefaultVertexFormats.field_181709_i);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textureRl);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)(y + (isGui ? 0.0f : options.getFontScale())), (float)0.0f);
        this.zIndex = z;
        if (!isGui) {
            GL11.glScalef((float)0.11111111f, (float)-0.11111111f, (float)0.11111111f);
        }
    }

    protected void clean(MalisisRenderer<?> renderer, boolean isDrawing) {
        if (isDrawing) {
            renderer.next(MalisisRenderer.malisisVertexFormat);
        } else {
            renderer.draw();
        }
        if (renderer instanceof GuiRenderer) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(((GuiRenderer)renderer).getDefaultTexture().getResourceLocation());
        }
        GL11.glPopMatrix();
        this.zIndex = 0.0f;
    }

    protected void prepareShadow(MalisisRenderer<?> renderer) {
        this.drawingShadow = true;
        if (renderer instanceof GuiRenderer) {
            return;
        }
        renderer.next();
        GL11.glPolygonOffset((float)3.0f, (float)3.0f);
        GL11.glEnable((int)32823);
    }

    protected void cleanShadow(MalisisRenderer<?> renderer) {
        this.drawingShadow = false;
        if (renderer instanceof GuiRenderer) {
            return;
        }
        renderer.next();
        GL11.glPolygonOffset((float)0.0f, (float)0.0f);
        GL11.glDisable((int)32823);
    }

    protected void prepareLines(MalisisRenderer<?> renderer, FontOptions options) {
        renderer.next(DefaultVertexFormats.field_181706_f);
        renderer.disableTextures();
    }

    protected void cleanLines(MalisisRenderer<?> renderer) {
        renderer.next();
        renderer.enableTextures();
    }

    public void render(MalisisRenderer<?> renderer, List<String> lines, int startLine, int endLine, float x, float y, float z, int lineSpacing, FontOptions options) {
        if (lines.size() == 0) {
            return;
        }
        boolean isDrawing = renderer.isDrawing();
        this.prepare(renderer, x, y, z, options);
        try {
            StringWalker walker = new StringWalker(lines, this, options);
            walker.applyStyles(true);
            x = 0.0f;
            y = 0.0f;
            while (walker.walk() && walker.getCurrentLine() < endLine) {
                if (walker.getCurrentLine() < startLine) continue;
                options = walker.getCurrentStyle();
                this.renderCharacter(walker.getChar(), x, y, options);
                x += walker.getWidth();
                if (!walker.isEOL()) continue;
                y += this.getStringHeight(options) + (float)lineSpacing;
                x = 0.0f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clean(renderer, isDrawing);
    }

    public void render(MalisisRenderer<?> renderer, String text, float x, float y, float z, FontOptions options) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (this.font == null && this != minecraftFont) {
            minecraftFont.render(renderer, text, x, y, z, options);
            return;
        }
        text = this.processString(text, options);
        this.render(renderer, Lists.newArrayList((Object[])new String[]{text}), 0, 1, x, y, z, 0, options);
    }

    protected void renderCharacter(char c, float x, float y, FontOptions options) {
        CharData cd = this.getCharData(c);
        if (options.isObfuscated()) {
            cd = this.getRandomChar(cd);
        }
        float fs = options.getFontScale();
        if (options.hasShadow()) {
            this.drawChar(cd, x + fs, y + fs, options, options.getShadowColor());
            if (options.isBold()) {
                this.drawChar(cd, x + 2.0f * fs, y + fs, options, options.getShadowColor());
            }
            if (options.isUnderline()) {
                this.drawLine(cd, x + fs, y + 2.0f * fs, options, options.getShadowColor());
            }
        }
        this.drawChar(cd, x, y, options, options.getColor());
        if (options.isBold()) {
            this.drawChar(cd, x + fs, y, options, options.getColor());
        }
        if (options.isUnderline()) {
            this.drawLine(cd, x, y + fs, options, options.getColor());
        }
    }

    protected void drawChar(CharData cd, float offsetX, float offsetY, FontOptions options, int color) {
        if (Character.isWhitespace(cd.getChar())) {
            return;
        }
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        float factor = options.getFontScale() / this.fontGeneratorOptions.fontSize * 9.0f;
        float w = cd.getFullWidth(this.fontGeneratorOptions) * factor;
        float h = cd.getFullHeight(this.fontGeneratorOptions) * factor;
        float i = options.isItalic() ? options.getFontScale() : 0.0f;
        buffer.func_181662_b((double)(offsetX + i), (double)offsetY, (double)this.zIndex);
        buffer.func_187315_a((double)cd.u(), (double)cd.v());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX - i), (double)(offsetY + h), (double)this.zIndex);
        buffer.func_187315_a((double)cd.u(), (double)cd.V());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX + w - i), (double)(offsetY + h), (double)this.zIndex);
        buffer.func_187315_a((double)cd.U(), (double)cd.V());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX + w + i), (double)offsetY, (double)this.zIndex);
        buffer.func_187315_a((double)cd.U(), (double)cd.v());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
    }

    protected void drawLine(CharData cd, float offsetX, float offsetY, FontOptions options, int color) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        float factor = options.getFontScale() / this.fontGeneratorOptions.fontSize * 9.0f;
        float w = cd.getFullWidth(this.fontGeneratorOptions) * factor + options.getFontScale();
        if (options.isBold()) {
            w += options.getFontScale();
        }
        float h = cd.getFullHeight(this.fontGeneratorOptions) * factor;
        cd = this.getCharData('_');
        buffer.func_181662_b((double)offsetX, (double)offsetY, (double)this.zIndex);
        buffer.func_187315_a((double)cd.u(), (double)cd.v());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)offsetX, (double)(offsetY + h), (double)this.zIndex);
        buffer.func_187315_a((double)cd.u(), (double)cd.V());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX + w), (double)(offsetY + h), (double)this.zIndex);
        buffer.func_187315_a((double)cd.U(), (double)cd.V());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX + w), (double)offsetY, (double)this.zIndex);
        buffer.func_187315_a((double)cd.U(), (double)cd.v());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
    }

    public CharData getRandomChar(CharData cd) {
        int index;
        Random rand = Minecraft.func_71410_x().field_71466_p.field_78289_c;
        float w = cd.getCharWidth();
        while ((cd = this.getCharData(CHARLIST.charAt(index = rand.nextInt(CHARLIST.length())))).getCharWidth() != w) {
        }
        return cd;
    }

    public String processString(String str, FontOptions options) {
        str = str.replaceAll("\r?\n", "");
        if (!options.shouldTranslate()) {
            return str;
        }
        Pair<String, String> p = FontOptions.getStartFormat(str);
        return (String)p.getLeft() + this.translate((String)p.getRight());
    }

    private String translate(String str) {
        if (str.indexOf(123) == -1 || str.indexOf(123) >= str.indexOf(125)) {
            return I18n.func_135052_a((String)str, (Object[])new Object[0]);
        }
        StringBuffer output = new StringBuffer();
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            matcher.appendReplacement(output, I18n.func_135052_a((String)matcher.group(1), (Object[])new Object[0]));
        }
        matcher.appendTail(output);
        return output.toString();
    }

    public String clipString(String str, int width, FontOptions options) {
        return this.clipString(str, width, options, false);
    }

    public String clipString(String str, int width, FontOptions options, boolean appendPeriods) {
        str = this.processString(str, options);
        if (appendPeriods) {
            width -= 4;
        }
        int pos = (int)this.getCharPosition(str, options, width, 0);
        return str.substring(0, pos) + (pos < str.length() && appendPeriods ? "..." : "");
    }

    public float getStringWidth(String str, FontOptions options, int start, int end) {
        if (this.font == null) {
            return minecraftFont.getStringWidth(str, options, start, end);
        }
        if (start > end) {
            return 0.0f;
        }
        if (options != null && !options.isFormattingDisabled()) {
            str = TextFormatting.func_110646_a((String)str);
        }
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        str = this.processString(str, options);
        return (float)this.font.getStringBounds(str, this.frc).getWidth() / this.fontGeneratorOptions.fontSize * (options != null ? options.getFontScale() : 1.0f) * 9.0f;
    }

    public float getStringWidth(String str, FontOptions options) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        return this.getStringWidth(str, options, 0, 0);
    }

    public float getStringHeight() {
        return this.getStringHeight(null);
    }

    public float getStringHeight(FontOptions options) {
        return (options != null ? options.getFontScale() : 1.0f) * 9.0f;
    }

    public float getMaxStringWidth(List<String> strings) {
        return this.getMaxStringWidth(strings, null);
    }

    public float getMaxStringWidth(List<String> strings, FontOptions options) {
        float width = 0.0f;
        for (String str : strings) {
            width = Math.max(width, this.getStringWidth(str, options));
        }
        return width;
    }

    public float getCharWidth(char c) {
        return this.getCharWidth(c, null);
    }

    public float getCharWidth(char c, FontOptions options) {
        if (c == '\r' || c == '\n') {
            return 0.0f;
        }
        if (c == '\t') {
            return this.getCharWidth(' ', options) * 4.0f;
        }
        return this.getCharData(c).getCharWidth() / this.fontGeneratorOptions.fontSize * (options != null ? options.getFontScale() : 1.0f) * 9.0f;
    }

    public float getCharPosition(String str, FontOptions options, int position, int charOffset) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        str = this.processString(str, options);
        StringWalker walker = new StringWalker(str, this, options);
        walker.startIndex(charOffset);
        walker.skipChars(true);
        return walker.walkToCoord(position);
    }

    public List<String> wrapText(String str, int maxWidth, FontOptions options) {
        ArrayList lines = Lists.newArrayList();
        String[] texts = str.split("\r?(?<=\n)");
        if (texts.length > 1) {
            for (String t : texts) {
                lines.addAll(this.wrapText(t, maxWidth, options));
            }
            return lines;
        }
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        maxWidth -= 4;
        float lineWidth = 0.0f;
        float wordWidth = 0.0f;
        texts = (str = this.processString(str, options)).split("\\\\r?\\\\n");
        if (texts.length > 1) {
            for (String t : texts) {
                lines.addAll(this.wrapText(t, maxWidth, options));
            }
            return lines;
        }
        StringWalker walker = new StringWalker(str, this, options);
        walker.skipChars(false);
        walker.applyStyles(true);
        while (walker.walk()) {
            char c = walker.getChar();
            lineWidth += walker.getWidth();
            wordWidth += walker.getWidth();
            word.append(c);
            if (c == ' ' || c == '-' || c == '.') {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0.0f;
            }
            if (!(lineWidth >= (float)maxWidth)) continue;
            if (line.length() == 0) {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0.0f;
            }
            lines.add(line.toString());
            line.setLength(0);
            lineWidth = wordWidth;
        }
        line.append((CharSequence)word);
        lines.add(line.toString());
        return lines;
    }

    protected void loadCharacterData() {
        this.frc = new FontRenderContext(null, true, true);
        float totalWidth = 0.0f;
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            CharData cd;
            String s = "" + c;
            LineMetrics lm = this.font.getLineMetrics(s, this.frc);
            Rectangle2D bounds = this.font.getStringBounds(s, this.frc);
            this.charData[c] = cd = new CharData(c, lm.getAscent(), (float)bounds.getWidth(), this.fontGeneratorOptions.fontSize);
            totalWidth += cd.getFullWidth(this.fontGeneratorOptions);
        }
        int split = 1;
        while (totalWidth / (float)split > this.fontGeneratorOptions.fontSize * (float)split) {
            ++split;
        }
        this.size = this.roundUp((int)totalWidth / (split - 1));
    }

    protected int roundUp(int n) {
        int r = n - 1;
        r |= r >> 1;
        r |= r >> 2;
        r |= r >> 4;
        r |= r >> 8;
        r |= r >> 16;
        return r + 1;
    }

    protected void loadTexture(boolean forceGenerate) {
        BufferedImage img;
        File textureFile = new File("fonts/" + this.font.getName() + ".png");
        File uvFile = new File("fonts/" + this.font.getName() + ".bin");
        if (!textureFile.exists() || !uvFile.exists() || forceGenerate) {
            MalisisCore.log.info("Generating files for " + this.font.getName());
            img = new FontGenerator(this.font, this.charData, this.fontGeneratorOptions).generate(this.size, textureFile, uvFile);
        } else {
            MalisisCore.log.info("Loading texture and data for " + this.font.getName());
            img = this.readTextureFile(textureFile);
            this.readUVFile(uvFile);
        }
        if (img == null) {
            return;
        }
        if (this.textureRl != null) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(this.textureRl);
        }
        DynamicTexture dynTex = new DynamicTexture(img);
        this.textureRl = Minecraft.func_71410_x().func_110434_K().func_110578_a(this.font.getName(), dynTex);
    }

    protected BufferedImage readTextureFile(File textureFile) {
        try {
            BufferedImage img = ImageIO.read(textureFile);
            if (img == null) {
                MalisisCore.log.error("Failed to read font texture, no image could be read from the file.");
                return null;
            }
            this.size = img.getWidth();
            return img;
        }
        catch (IOException e) {
            MalisisCore.log.error("Failed to read font texture.", (Throwable)e);
            return null;
        }
    }

    protected void readUVFile(File uvFile) {
        int i = 0;
        try {
            for (String str : Files.readLines((File)uvFile, (Charset)StandardCharsets.UTF_8)) {
                String[] split = str.split(";");
                CharData cd = this.charData[i++];
                cd.setUVs(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4]));
            }
        }
        catch (IOException | NumberFormatException e) {
            MalisisCore.log.error("Failed to read font data. (Line " + i + " (" + (char)i + ")", (Throwable)e);
        }
    }

    public static Font load(ResourceLocation rl, FontGeneratorOptions options) {
        try {
            return MalisisFont.load(Minecraft.func_71410_x().func_110442_L().func_110536_a(rl).func_110527_b(), options);
        }
        catch (IOException e) {
            MalisisCore.log.error("[MalisiFont] Couldn't load font from ResourceLocation.", (Throwable)e);
            return null;
        }
    }

    public static Font load(File file, FontGeneratorOptions options) {
        try {
            return MalisisFont.load(new FileInputStream(file), options);
        }
        catch (FileNotFoundException e) {
            MalisisCore.log.error("[MalisiFont] Couldn't load font from File.", (Throwable)e);
            return null;
        }
    }

    public static Font load(InputStream is, FontGeneratorOptions options) {
        try {
            Font font = Font.createFont(options.fontType, is);
            return font.deriveFont(options.fontSize);
        }
        catch (FontFormatException | IOException e) {
            MalisisCore.log.error("[MalisiFont] Couldn't load font from InputStream.", (Throwable)e);
            return null;
        }
    }
}

