/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class StringWalker {
    private static FontOptions DEFAULT_OPTIONS = FontOptions.builder().build();
    protected MalisisFont font;
    protected String str;
    protected boolean litteral;
    protected boolean skipChars = true;
    protected boolean applyStyles;
    protected List<String> lines;
    protected int currentLine;
    protected boolean isEOL = true;
    protected int index;
    protected int endIndex;
    protected char c;
    protected TextFormatting format;
    protected float width;
    protected LinkedList<FontOptions> styles = Lists.newLinkedList();

    public StringWalker(String str, MalisisFont font, FontOptions options) {
        this.str = str;
        this.font = font;
        this.styles.add(options != null ? options : DEFAULT_OPTIONS);
        this.index = 0;
        this.endIndex = str.length();
        this.litteral = options != null && options.isFormattingDisabled();
    }

    public StringWalker(List<String> lines, MalisisFont font, FontOptions options) {
        this(lines.size() > 0 ? lines.get(0) : "", font, options);
        this.lines = lines;
    }

    public void setLitteral(boolean litteral) {
        this.litteral = litteral;
    }

    public void skipChars(boolean skip) {
        this.skipChars = skip;
    }

    public void applyStyles(boolean apply) {
        this.applyStyles = apply;
    }

    public boolean isApplyStyles() {
        return this.applyStyles;
    }

    public int getIndex() {
        return this.index;
    }

    public char getChar() {
        return this.c;
    }

    public TextFormatting getFormatting() {
        return this.format;
    }

    public boolean isFormatted() {
        return this.format != null;
    }

    public float getWidth() {
        return this.width;
    }

    public void startIndex(int index) {
        this.index = MathHelper.func_76125_a((int)index, (int)0, (int)this.endIndex);
    }

    public void endIndex(int index) {
        if (index == 0) {
            index = this.str.length();
        }
        this.endIndex = MathHelper.func_76125_a((int)index, (int)index, (int)this.str.length());
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public String getCurrentText() {
        return this.lines.size() > this.getCurrentLine() ? this.lines.get(this.getCurrentLine()) : "";
    }

    public FontOptions getCurrentStyle() {
        return this.styles.getLast();
    }

    public boolean isEOL() {
        return this.index >= this.endIndex;
    }

    public boolean isEndOfText() {
        return this.isEOL() && (this.lines == null || this.currentLine >= this.lines.size() - 1);
    }

    protected void checkFormatting() {
        this.format = FontOptions.getFormatting(this.str, this.index);
        if (this.format == null) {
            this.format = FontOptions.getFormatting(this.str, this.index - 1);
        }
        if (this.format == null) {
            return;
        }
        if (this.applyStyles) {
            this.applyStyle(this.format);
        }
        if (this.skipChars && !this.litteral) {
            this.index += 2;
            this.checkFormatting();
        }
    }

    protected void applyStyle(TextFormatting format) {
        if (format == TextFormatting.RESET) {
            FontOptions fontOptions = this.styles.getFirst();
            this.styles.clear();
            this.styles.add(fontOptions);
            return;
        }
        FontOptions.FontOptionsBuilder builder = this.getCurrentStyle().toBuilder();
        builder.styles(format);
        this.styles.add(builder.build());
    }

    public float walkToCharacter(int c) {
        this.endIndex(c);
        float w = 0.0f;
        while (this.walk()) {
            w += this.getWidth();
        }
        return w;
    }

    public int walkToCoord(float x) {
        if (x < 0.0f) {
            return this.getIndex();
        }
        float width = 0.0f;
        while (this.walk()) {
            if (!((width += this.getWidth()) > x)) continue;
            return this.getIndex() - 1;
        }
        return this.getIndex();
    }

    public boolean walk() {
        if (this.walkLine()) {
            return true;
        }
        if (this.isEndOfText()) {
            return false;
        }
        this.str = this.lines.get(++this.currentLine);
        this.index = 0;
        this.endIndex = this.str.length();
        this.width = 0.0f;
        return true;
    }

    private boolean walkLine() {
        if (this.isEOL()) {
            return false;
        }
        this.checkFormatting();
        if (this.isEOL()) {
            return false;
        }
        FontOptions options = this.styles.getLast();
        this.c = this.str.charAt(this.index);
        this.width = this.font.getCharWidth(this.c, options);
        if (options.isBold()) {
            this.width += options.getFontScale();
        }
        if (!this.litteral && !this.skipChars && this.format != null) {
            this.width = 0.0f;
        }
        ++this.index;
        return true;
    }
}

