/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import xyz.przemyk.simpleplanes.Config;
import xyz.przemyk.simpleplanes.PlaneMaterial;
import xyz.przemyk.simpleplanes.SimplePlanesMod;
import xyz.przemyk.simpleplanes.entities.EntitySize;
import xyz.przemyk.simpleplanes.handler.PlaneNetworking;
import xyz.przemyk.simpleplanes.math.MathUtil;
import xyz.przemyk.simpleplanes.math.Quaternion;
import xyz.przemyk.simpleplanes.math.Vector3f;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesMaterials;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesSounds;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class PlaneEntity
extends Entity
implements IEntityAdditionalSpawnData {
    protected static final DataParameter<Integer> FUEL = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> MAX_FUEL = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final EntitySize FLYING_SIZE = EntitySize.flexible(2.0f, 1.5f);
    public static final EntitySize STANDING_SIZE = EntitySize.flexible(2.0f, 0.5f);
    public static final EntitySize FLYING_SIZE_EASY = EntitySize.flexible(2.0f, 2.0f);
    public static final DataParameter<Integer> MAX_HEALTH = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> HEALTH = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> MAX_SPEED = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Quaternion> Q = EntityDataManager.func_187226_a(PlaneEntity.class, SimplePlanesDataSerializers.QUATERNION_SERIALIZER);
    public static final DataParameter<String> MATERIAL = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_187194_d);
    public Quaternion Q_Client = new Quaternion();
    public Quaternion Q_Prev = new Quaternion();
    public static final DataParameter<NBTTagCompound> UPGRADES_NBT = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_192734_n);
    public static final DataParameter<Integer> ROCKING_TICKS = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(PlaneEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(-1.0, 0.0, -1.0, 1.0, 0.5, 1.0);
    protected int poweredTicks;
    private int groundTicks;
    public HashMap<ResourceLocation, Upgrade> upgrades = new HashMap();
    public float rotationRoll;
    public float prevRotationRoll;
    private float deltaRotation;
    private float deltaRotationLeft;
    private int deltaRotationTicks;
    private PlaneMaterial material;
    public boolean mountmassage;
    private int hurtTime;
    public int not_moving_time;
    public int health_timer = 0;
    private int lerpSteps;
    private int lerpStepsQ;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private boolean rocking;
    private boolean field_203060_aN;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;

    public PlaneEntity(World worldIn) {
        this(worldIn, SimplePlanesMaterials.OAK);
    }

    public PlaneEntity(World worldIn, PlaneMaterial material) {
        super(worldIn);
        this.field_70138_W = 0.9999f;
        this.setMaterial(material);
        this.setMaxSpeed(1.0f);
        EntitySize size = this.getSize();
        this.setSize(size);
    }

    private void setSize(EntitySize size) {
        this.func_70105_a(size.width, size.hight);
    }

    public PlaneEntity(World worldIn, PlaneMaterial material, double x, double y, double z) {
        this(worldIn, material);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUEL, (Object)0);
        this.field_70180_af.func_187214_a(MAX_FUEL, (Object)Config.INSTANCE.COAL_MAX_FUEL);
        this.field_70180_af.func_187214_a(MAX_HEALTH, (Object)10);
        this.field_70180_af.func_187214_a(HEALTH, (Object)10);
        this.field_70180_af.func_187214_a(UPGRADES_NBT, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(Q, (Object)new Quaternion());
        this.field_70180_af.func_187214_a(MAX_SPEED, (Object)Float.valueOf(0.25f));
        this.field_70180_af.func_187214_a(MATERIAL, (Object)"oak");
        this.field_70180_af.func_187214_a(ROCKING_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
    }

    public void addFuelMaxed() {
        this.addFuelMaxed(Config.INSTANCE.FLY_TICKS_PER_COAL);
    }

    public void addFuelMaxed(Integer fuel) {
        if (!this.field_70170_p.field_72995_K) {
            int old_fuel = this.getFuel();
            int new_fuel = old_fuel + fuel;
            if (new_fuel > fuel * 3) {
                new_fuel = old_fuel + fuel / 3;
            }
            this.field_70180_af.func_187227_b(FUEL, (Object)new_fuel);
        }
    }

    public void addFuel(Integer fuel) {
        if (!this.field_70170_p.field_72995_K) {
            int old_fuel = this.getFuel();
            int new_fuel = old_fuel + fuel;
            this.field_70180_af.func_187227_b(FUEL, (Object)new_fuel);
        }
    }

    public void setFuel(Integer fuel) {
        this.field_70180_af.func_187227_b(FUEL, (Object)fuel);
    }

    public int getFuel() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL);
    }

    public float getMaxSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue();
    }

    public void setMaxSpeed(float max_speed) {
        this.field_70180_af.func_187227_b(MAX_SPEED, (Object)Float.valueOf(max_speed));
    }

    public float getMaxFuel() {
        return ((Integer)this.field_70180_af.func_187225_a(MAX_FUEL)).intValue();
    }

    public void setMaxFuel(int max_fuel) {
        this.field_70180_af.func_187227_b(MAX_FUEL, (Object)max_fuel);
    }

    public Quaternion getQ() {
        return new Quaternion((Quaternion)this.field_70180_af.func_187225_a(Q));
    }

    public void setQ(Quaternion q) {
        this.field_70180_af.func_187227_b(Q, (Object)q);
    }

    public Quaternion getQ_Client() {
        return new Quaternion(this.Q_Client);
    }

    public void setQ_Client(Quaternion q) {
        this.Q_Client = q;
    }

    public Quaternion getQ_Prev() {
        return new Quaternion(this.Q_Prev);
    }

    public void setQ_prev(Quaternion q) {
        this.Q_Prev = q;
    }

    public PlaneMaterial getMaterial() {
        return this.material;
    }

    public void setHealth(Integer health) {
        this.field_70180_af.func_187227_b(HEALTH, (Object)Math.max(health, 0));
    }

    public int getHealth() {
        return (Integer)this.field_70180_af.func_187225_a(HEALTH);
    }

    public void setMaxHealth(Integer maxHealth) {
        this.field_70180_af.func_187227_b(MAX_HEALTH, (Object)maxHealth);
    }

    public int getMaxHealth() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_HEALTH);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getItemStack();
    }

    public void setMaterial(String material) {
        this.field_70180_af.func_187227_b(MATERIAL, (Object)material);
        this.material = SimplePlanesMaterials.getMaterial(material);
    }

    public void setMaterial(PlaneMaterial material) {
        this.field_70180_af.func_187227_b(MATERIAL, (Object)material.name);
        this.material = material;
        this.field_70178_ae = this.material.fireResistant;
    }

    public boolean isPowered() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL) > 0 || this.isCreative();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.tryToAddUpgrade(player, itemStack)) {
            return true;
        }
        if (player.func_70093_af() && itemStack.func_190926_b()) {
            boolean hasplayer = false;
            for (Entity passenger : this.func_184188_bt()) {
                if (!(passenger instanceof EntityPlayer)) continue;
                hasplayer = true;
                break;
            }
            if (!hasplayer || Config.INSTANCE.THIEF) {
                this.func_184226_ay();
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.rightClickUpgrades(player, hand, itemStack);
            return player.func_184220_m((Entity)this);
        }
        return player.func_184208_bv() == this.func_184208_bv();
    }

    public void rightClickUpgrades(EntityPlayer player, EnumHand hand, ItemStack itemStack) {
        HashSet<Upgrade> upgradesToRemove = new HashSet<Upgrade>();
        for (Upgrade upgrade : this.upgrades.values()) {
            if (!upgrade.onItemRightClick(player, this.field_70170_p, hand, itemStack)) continue;
            upgradesToRemove.add(upgrade);
        }
        for (Upgrade upgrade : upgradesToRemove) {
            this.upgrades.remove(upgrade.getType().getRegistryName());
        }
        if (!upgradesToRemove.isEmpty()) {
            this.upgradeChanged();
        }
    }

    public boolean tryToAddUpgrade(EntityPlayer player, ItemStack itemStack) {
        for (UpgradeType upgradeType : SimplePlanesRegistries.UPGRADE_TYPES.getValues()) {
            if (!upgradeType.IsThisItem(itemStack) || !this.canAddUpgrade(upgradeType)) continue;
            this.upgrade(player, itemStack, upgradeType);
            return true;
        }
        return false;
    }

    public void upgrade(EntityPlayer player, ItemStack itemStack, UpgradeType upgradeType) {
        Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
        upgrade.onApply(itemStack, player);
        if (!player.func_184812_l_()) {
            itemStack.func_190918_g(1);
        }
        this.upgrades.put(upgradeType.getRegistryName(), upgrade);
        this.upgradeChanged();
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)entityIn;
            if (arrow.field_70250_c != null && this.func_184223_x(arrow.field_70250_c)) {
                return;
            }
        }
        super.func_70108_f(entityIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean creative_player;
        this.setTimeSinceHit(20);
        this.setDamageTaken(this.getDamageTaken() + 10.0f * amount);
        if (this.isInvulnerableTo(source) || this.hurtTime > 0) {
            return false;
        }
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        int health = this.getHealth();
        if (health < 0) {
            return false;
        }
        health = (int)((float)health - amount);
        this.setHealth(health);
        this.hurtTime = 10;
        boolean is_player = source.func_76346_g() instanceof EntityPlayer;
        boolean bl = creative_player = is_player && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
        if (creative_player || is_player && this.getDamageTaken() > 30.0f || health <= 0) {
            if (!creative_player) {
                this.explode();
            }
            this.func_70106_y();
        }
        return true;
    }

    private void explode() {
        ((WorldServer)this.field_70170_p).func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.getPosX(), this.getPosY(), this.getPosZ(), 5.0, 1.0, 1.0, new int[]{1, 2});
        this.field_70170_p.func_72876_a((Entity)this, this.getPosX(), this.getPosY(), this.getPosZ(), 0.0f, false);
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            this.dropItem();
        }
    }

    protected void dropItem() {
        ItemStack itemStack = new ItemStack(this.getItem());
        NBTTagCompound value = new NBTTagCompound();
        value.func_74757_a("Used", true);
        itemStack.func_77983_a("Used", (NBTBase)value);
        this.entityDropItem(itemStack);
        for (Upgrade upgrade : this.upgrades.values()) {
            NonNullList<ItemStack> items = upgrade.getDrops();
            for (ItemStack item : items) {
                if (item == null) continue;
                this.entityDropItem(item);
            }
        }
    }

    public EntityItem entityDropItem(ItemStack itemStack) {
        return this.func_70099_a(itemStack, 0.0f);
    }

    public EntitySize getSize() {
        if (this.func_184179_bs() instanceof EntityPlayer) {
            return this.isEasy() ? FLYING_SIZE_EASY : FLYING_SIZE;
        }
        return STANDING_SIZE;
    }

    public boolean func_241845_aY() {
        return true;
    }

    public void func_70071_h_() {
        EntityLivingBase controllingPassenger;
        super.func_70071_h_();
        if (Double.isNaN(this.getMotion().func_72433_c())) {
            this.setMotion(Vec3d.field_186680_a);
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.prevRotationRoll = this.rotationRoll;
        if (this.isPowered()) {
            if (this.poweredTicks % 50 == 0) {
                this.func_184185_a(SimplePlanesSounds.PLANE_LOOP, 0.05f, 1.0f);
            }
            ++this.poweredTicks;
        } else {
            this.poweredTicks = 0;
        }
        if (this.field_70170_p.field_72995_K && !this.func_184186_bw()) {
            this.tickLerp();
            this.setMotion(Vec3d.field_186680_a);
            this.tickDeltaRotation(this.getQ_Client());
            this.tickUpgrades();
            this.recalculateSize();
            return;
        }
        this.func_70018_K();
        Vars vars = this.getMotionVars();
        if (this.func_189652_ae()) {
            vars.gravity = 0.0;
            vars.max_lift = 0.0f;
            vars.push = 0.0f;
            vars.passive_engine_push = 0.0f;
        }
        vars.moveForward = (controllingPassenger = (EntityLivingBase)this.func_184179_bs()) instanceof EntityPlayer ? controllingPassenger.field_191988_bg : 0.0f;
        vars.turn_threshold = (double)Config.INSTANCE.TURN_THRESHOLD / 100.0;
        if ((double)MathUtil.func_76135_e((float)vars.moveForward) < vars.turn_threshold) {
            vars.moveForward = 0.0f;
        }
        float f = vars.moveStrafing = controllingPassenger instanceof EntityPlayer ? controllingPassenger.field_70702_br : 0.0f;
        if ((double)MathUtil.func_76135_e((float)vars.moveStrafing) < vars.turn_threshold) {
            vars.moveStrafing = 0.0f;
        }
        if (this.getPlayer() == null) {
            this.func_70031_b(false);
        }
        vars.passengerSprinting = this.func_70051_ag();
        Quaternion q = this.field_70170_p.field_72995_K ? this.getQ_Client() : this.getQ();
        MathUtil.EulerAngles angelsOld = MathUtil.toEulerAngles(q).copy();
        Vec3d oldMotion = this.getMotion();
        this.recalculateSize();
        int fuel = (Integer)this.field_70180_af.func_187225_a(FUEL);
        if (fuel > 0 && !this.isParked(vars)) {
            this.setFuel(fuel -= this.getFuelCost(vars));
        }
        if (this.getMotion().func_72433_c() > 0.05) {
            q = this.tickRotateMotion(vars, q, this.getMotion());
        }
        boolean do_pitch = true;
        if (this.getOnGround() || this.isAboveWater()) {
            do_pitch = this.tickOnGround(vars);
        } else {
            --this.groundTicks;
            if (!vars.passengerSprinting) {
                vars.push = vars.passive_engine_push;
            }
        }
        if (do_pitch) {
            this.tickPitch(vars);
        }
        this.tickMotion(vars);
        this.tickRotation(vars);
        this.tickUpgrades();
        double l = 0.002;
        if (oldMotion.func_72433_c() < l && this.getMotion().func_72433_c() < l && this.groundTicks > -50) {
            this.setMotion(Vec3d.field_186680_a);
        }
        this.recalculateSize();
        if (!this.field_70122_E || this.horizontalMag(this.getMotion()) > (double)1.0E-5f || (this.field_70173_aa + this.func_145782_y()) % 4 == 0) {
            double speed_after;
            double speed_diff;
            float f2;
            double speed_before = Math.sqrt(this.horizontalMag(this.getMotion()));
            boolean onGroundOld = this.field_70122_E;
            Vec3d preMotion = this.getMotion();
            if (preMotion.func_72433_c() > 0.5 || vars.moveForward != 0.0f) {
                this.field_70122_E = true;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            boolean bl = this.field_70122_E = preMotion.field_72448_b == 0.0 ? onGroundOld : this.field_70122_E;
            if (this.field_70123_F && !this.field_70170_p.field_72995_K && Config.INSTANCE.PLANE_CRASH && this.groundTicks <= 0 && (f2 = (float)((speed_diff = speed_before - (speed_after = Math.sqrt(this.horizontalMag(this.getMotion())))) * 10.0 - 5.0)) > 5.0f) {
                this.crash(f2);
            }
        }
        if (this.isPowered() && this.field_70146_Z.nextInt(vars.passengerSprinting ? 2 : 4) == 0 && !this.field_70170_p.field_72995_K) {
            this.spawnSmokeParticles(fuel);
        }
        MathUtil.hamiltonProduct(q, MathUtil.rotationDegreesZ((float)((double)this.rotationRoll - angelsOld.roll)));
        MathUtil.hamiltonProduct(q, MathUtil.rotationDegreesX((float)(-((double)this.field_70125_A - angelsOld.pitch))));
        MathUtil.hamiltonProduct(q, MathUtil.rotationDegreesY((float)((double)this.field_70177_z - angelsOld.yaw)));
        q = MathUtil.normalizeQuaternion(q);
        this.setQ_prev(this.getQ_Client());
        this.setQ(q);
        this.tickDeltaRotation(q);
        if (this.field_70170_p.field_72995_K && this.func_184186_bw()) {
            this.setQ_Client(q);
            PlaneNetworking.INSTANCE.sendToServer((IMessage)new PlaneNetworking.QuaternionMSG.MSG(this.getQ()));
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.field_70170_p.field_72995_K && this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.getHealth() > this.getMaxHealth() & this.health_timer > (this.getOnGround() ? 300 : 100)) {
            this.setHealth(this.getHealth() - 1);
            this.health_timer = 0;
        }
        if (this.health_timer < 1000 && this.isPowered()) {
            ++this.health_timer;
        }
        this.tickLerp();
    }

    public double horizontalMag(Vec3d motion) {
        return motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c;
    }

    public void recalculateSize() {
        this.setSize(this.getSize());
    }

    public Vec3d getMotion() {
        return new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void tickUpgrades() {
        HashSet<Upgrade> upgradesToRemove = new HashSet<Upgrade>();
        for (Upgrade upgrade : this.upgrades.values()) {
            if (!upgrade.tick()) continue;
            upgradesToRemove.add(upgrade);
        }
        for (Upgrade upgrade : upgradesToRemove) {
            this.upgrades.remove(upgrade.getType().getRegistryName());
        }
        if (!upgradesToRemove.isEmpty()) {
            this.upgradeChanged();
        }
    }

    public boolean isFull() {
        return this.func_184188_bt().size() > 0;
    }

    public int getFuelCost(Vars vars) {
        return vars.passengerSprinting ? 4 : 1;
    }

    public boolean isParked(Vars vars) {
        Vec3d oldMotion = this.getMotion();
        boolean parked = (this.isAboveWater() || this.isOnGround()) && oldMotion.func_72433_c() < 0.1 && !vars.passengerSprinting && vars.moveStrafing == 0.0f && vars.moveForward == 0.0f;
        return parked;
    }

    private boolean isOnGround() {
        return this.field_70122_E;
    }

    protected Vars getMotionVars() {
        return new Vars();
    }

    protected void tickDeltaRotation(Quaternion q) {
        MathUtil.EulerAngles angels1 = MathUtil.toEulerAngles(q);
        this.field_70125_A = (float)angels1.pitch;
        this.field_70177_z = (float)angels1.yaw;
        this.rotationRoll = (float)angels1.roll;
        float d = (float)MathUtil.wrapSubtractDegrees(this.field_70126_B, this.field_70177_z);
        if (this.rotationRoll >= 90.0f && this.prevRotationRoll <= 90.0f) {
            d = 0.0f;
        }
        int diff = 3;
        this.deltaRotationTicks = Math.min(10, Math.max((int)Math.abs(this.deltaRotationLeft) * 5, this.deltaRotationTicks));
        this.deltaRotationLeft = (float)((double)this.deltaRotationLeft * 0.7);
        this.deltaRotationLeft += d;
        this.deltaRotationLeft = MathHelper.func_76142_g((float)this.deltaRotationLeft);
        this.deltaRotation = Math.min(MathUtil.func_76135_e((float)this.deltaRotationLeft), (float)diff) * Math.signum(this.deltaRotationLeft);
        this.deltaRotationLeft -= this.deltaRotation;
        if (!(this.deltaRotation > 0.0f)) {
            --this.deltaRotationTicks;
        }
    }

    protected void tickRotation(Vars vars) {
        float f1 = 1.0f;
        double turn = 0.0;
        float moveStrafing = vars.moveStrafing;
        boolean passengerSprinting = vars.passengerSprinting;
        if (this.getOnGround() || this.isAboveWater() || !passengerSprinting || this.isEasy()) {
            int yawdiff = 2;
            float roll = this.rotationRoll;
            if (MathUtil.degreesDifferenceAbs(this.field_70125_A, 0.0) < 45.0) {
                for (int i = 0; i < 360; i += 180) {
                    if (!(MathUtil.degreesDifferenceAbs(this.rotationRoll, i) < 80.0)) continue;
                    roll = MathUtil.lerpAngle(0.1f * f1, this.rotationRoll, i);
                    break;
                }
            }
            int r = 15;
            if (this.getOnGround() || this.isAboveWater()) {
                turn = moveStrafing > 0.0f ? (double)yawdiff : (moveStrafing == 0.0f ? 0.0 : (double)(-yawdiff));
                this.rotationRoll = roll;
            } else if (MathUtil.degreesDifferenceAbs(this.rotationRoll, 0.0) > 30.0) {
                turn = moveStrafing > 0.0f ? (double)(-yawdiff) : (moveStrafing == 0.0f ? 0.0 : (double)yawdiff);
                this.rotationRoll = roll;
            } else {
                if (moveStrafing == 0.0f) {
                    this.rotationRoll = MathUtil.lerpAngle180(0.2f, this.rotationRoll, 0.0f);
                } else if (moveStrafing > 0.0f) {
                    this.rotationRoll = MathUtil.func_76131_a((float)(this.rotationRoll + f1), (float)0.0f, (float)r);
                } else if (moveStrafing < 0.0f) {
                    this.rotationRoll = MathUtil.func_76131_a((float)(this.rotationRoll - f1), (float)(-r), (float)0.0f);
                }
                double roll_old = MathUtil.toEulerAngles((Quaternion)this.getQ()).roll;
                turn = MathUtil.degreesDifferenceAbs(roll_old, 0.0) < 90.0 ? MathHelper.func_151237_a((double)(roll_old * (double)vars.yaw_multiplayer), (double)(-yawdiff), (double)yawdiff) : MathHelper.func_151237_a((double)((180.0 - roll_old) * (double)vars.yaw_multiplayer), (double)(-yawdiff), (double)yawdiff);
                if (moveStrafing == 0.0f) {
                    turn = 0.0;
                }
            }
        } else if (moveStrafing == 0.0f) {
            for (int i = 0; i < 360; i += 180) {
                if (!(MathUtil.degreesDifferenceAbs(this.rotationRoll, i) < 80.0)) continue;
                this.rotationRoll = MathUtil.lerpAngle(0.01f * f1, this.rotationRoll, i);
                break;
            }
        } else if (moveStrafing > 0.0f) {
            this.rotationRoll += f1;
        } else if (moveStrafing < 0.0f) {
            this.rotationRoll -= f1;
        }
        this.field_70177_z = (float)((double)this.field_70177_z - turn);
    }

    protected boolean isEasy() {
        return Config.INSTANCE.EASY_FLIGHT;
    }

    protected void tickMotion(Vars vars) {
        if (!this.isPowered()) {
            vars.push = 0.0f;
        }
        Vec3d motion = this.getMotion();
        double speed = motion.func_72433_c();
        double speed_x = MathUtil.getHorizontalLength(motion);
        speed -= speed * speed * vars.drag_quad + speed * vars.drag_mul + vars.drag;
        if ((speed = Math.max(speed, 0.0)) > vars.max_speed) {
            speed = MathUtil.lerp(0.2, speed, vars.max_speed);
        }
        if (speed == 0.0) {
            motion = Vec3d.field_186680_a;
        }
        if (motion.func_72433_c() > 0.0) {
            motion = motion.func_186678_a(speed / motion.func_72433_c());
        }
        Vector3f tickPush = this.getTickPush(vars);
        Vec3d pushVec = new Vec3d((double)tickPush.x, (double)tickPush.y, (double)tickPush.z);
        if (pushVec.func_72433_c() != 0.0 && motion.func_72433_c() > 0.1) {
            double dot = MathUtil.normalizedDotProduct(pushVec, motion);
            pushVec = pushVec.func_186678_a(MathUtil.func_151237_a((double)(1.0 - dot * speed / (vars.max_push_speed * ((double)vars.push + 0.05))), (double)0.0, (double)1.0));
        }
        motion = motion.func_178787_e(pushVec);
        motion = motion.func_72441_c(0.0, vars.gravity, 0.0);
        this.setMotion(motion);
    }

    protected Vector3f getTickPush(Vars vars) {
        return this.transformPos(new Vector3f(0.0f, 0.0f, vars.push));
    }

    protected void tickPitch(Vars vars) {
        float pitch = 0.0f;
        if (vars.moveForward > 0.0f) {
            pitch = vars.passengerSprinting ? 2.0f : 1.0f;
        } else if (vars.moveForward < 0.0f) {
            pitch = vars.passengerSprinting ? -2.0f : -1.0f;
        }
        this.field_70125_A += pitch;
    }

    protected boolean tickOnGround(Vars vars) {
        this.not_moving_time = this.getMotion().func_72433_c() < 0.1 && this.getOnGround() ? ++this.not_moving_time : 0;
        if (this.not_moving_time > 100 && this.getHealth() < this.getMaxHealth() && this.getPlayer() != null) {
            this.setHealth(this.getHealth() + 1);
            this.not_moving_time = 0;
        }
        boolean speeding_up = true;
        this.groundTicks = this.groundTicks < 0 ? 5 : --this.groundTicks;
        float pitch = this.getGroundPitch();
        if (this.isPowered() && vars.moveForward > 0.0f || this.isAboveWater()) {
            pitch = 0.0f;
        } else if (this.getMotion().func_72433_c() > vars.take_off_speed) {
            pitch /= 2.0f;
        }
        this.field_70125_A = MathUtil.lerpAngle(0.1f, this.field_70125_A, pitch);
        if (MathUtil.degreesDifferenceAbs(this.field_70125_A, 0.0) > 1.0 && this.getMotion().func_72433_c() < 0.1) {
            vars.push = 0.0f;
        }
        if (this.getMotion().func_72433_c() < vars.take_off_speed) {
            speeding_up = false;
        }
        if (vars.moveForward < 0.0f) {
            vars.push = -vars.ground_push;
        }
        if (!this.isPowered() || vars.moveForward == 0.0f) {
            vars.push = 0.0f;
        }
        BlockPos pos = new BlockPos(this.getPosX(), this.getPosY() - 1.0, this.getPosZ());
        IBlockState blockState = this.field_70170_p.func_180495_p(pos);
        float f = blockState.func_177230_c().getSlipperiness(blockState, (IBlockAccess)this.field_70170_p, pos, (Entity)this);
        vars.drag_mul *= (double)(20.0f * (3.0f - f));
        return speeding_up;
    }

    protected float getGroundPitch() {
        return 15.0f;
    }

    protected Quaternion tickRotateMotion(Vars vars, Quaternion q, Vec3d motion) {
        float d;
        float yaw = MathUtil.getYaw(motion);
        float pitch = MathUtil.getPitch(motion);
        if (MathUtil.degreesDifferenceAbs(yaw, this.field_70177_z) > 5.0) {
            double factor = this.getOnGround() || this.isAboveWater() ? 0.98 : 0.99;
            this.setMotion(motion.func_186678_a(factor));
        }
        if ((d = (float)MathUtil.degreesDifferenceAbs(pitch, this.field_70125_A)) > 180.0f) {
            d -= 180.0f;
        }
        d /= 60.0f;
        d = Math.min(1.0f, d);
        d *= d;
        d = 1.0f - d;
        double speed = this.getMotion().func_72433_c();
        double lift = Math.min(speed * vars.lift_factor, (double)vars.max_lift) * (double)d;
        double cos_roll = (1.0 + 4.0 * Math.max(Math.cos(Math.toRadians(MathUtil.degreesDifferenceAbs(this.rotationRoll, 0.0))), 0.0)) / 5.0;
        d = (float)((double)d * cos_roll);
        this.setMotion(MathUtil.rotationToVector(MathUtil.lerpAngle180(0.1f, yaw, this.field_70177_z), (double)MathUtil.lerpAngle180(vars.pitch_to_motion * d, pitch, this.field_70125_A) + (lift *= cos_roll), speed));
        if (!this.getOnGround() && !this.isAboveWater() && motion.func_72433_c() > 0.1) {
            if (MathUtil.degreesDifferenceAbs(pitch, this.field_70125_A) > 90.0) {
                pitch = MathHelper.func_76142_g((float)(pitch + 180.0f));
            }
            if (Math.abs(this.field_70125_A) < 85.0f) {
                yaw = MathUtil.getYaw(this.getMotion());
                if (MathUtil.degreesDifferenceAbs(yaw, this.field_70177_z) > 90.0) {
                    yaw -= 180.0f;
                }
                Quaternion q1 = MathUtil.toQuaternion(yaw, pitch, this.rotationRoll);
                q = MathUtil.lerpQ(vars.motion_to_rotation, q, q1);
            }
        }
        return q;
    }

    public void setMotion(Vec3d motion) {
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
    }

    public void setMotion(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
    }

    protected void spawnSmokeParticles(int fuel) {
        this.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, new Vector3f(0.0f, 0.8f, -1.0f), 0);
        if (fuel > 4 && fuel < Config.INSTANCE.FLY_TICKS_PER_COAL / 3) {
            this.spawnParticle(EnumParticleTypes.SMOKE_LARGE, new Vector3f(0.0f, 0.8f, -1.0f), 5);
        }
    }

    public void spawnParticle(EnumParticleTypes particleData, Vector3f relPos, int particleCount) {
        relPos = new Vector3f(relPos.getX(), relPos.getY() - 0.3f, relPos.getZ());
        relPos = this.transformPos(relPos);
        relPos = new Vector3f(relPos.getX(), relPos.getY() + 0.9f, relPos.getZ());
        Vec3d motion = this.getMotion();
        ((WorldServer)this.field_70170_p).func_175739_a(particleData, this.getPosX() + (double)relPos.getX(), this.getPosY() + (double)relPos.getY(), this.getPosZ() + (double)relPos.getZ(), 0, motion.field_72450_a, motion.field_72448_b + 1.0, motion.field_72449_c, motion.func_72433_c() / 4.0, new int[0]);
    }

    public Vector3f transformPos(Vector3f relPos) {
        relPos = new Vector3f(relPos);
        MathUtil.EulerAngles angels = MathUtil.toEulerAngles(this.getQ_Client());
        angels.yaw = -angels.yaw;
        angels.roll = -angels.roll;
        MathUtil.transformVec(relPos, MathUtil.toQuaternion(angels.yaw, angels.pitch, angels.roll));
        return relPos;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.field_70180_af.func_187227_b(FUEL, (Object)compound.func_74762_e("Fuel"));
        this.field_70180_af.func_187227_b(MAX_SPEED, (Object)Float.valueOf(compound.func_74760_g("max_speed")));
        int max_health = compound.func_74762_e("max_health");
        if (max_health <= 0) {
            max_health = 20;
        }
        this.field_70180_af.func_187227_b(MAX_HEALTH, (Object)max_health);
        int health = compound.func_74762_e("health");
        if (health <= 0) {
            health = 1;
        }
        this.field_70180_af.func_187227_b(HEALTH, (Object)health);
        String material = compound.func_74779_i("material");
        if (material.isEmpty()) {
            material = "oak";
        }
        this.setMaterial(material);
        NBTTagCompound upgradesNBT = compound.func_74775_l("upgrades");
        this.field_70180_af.func_187227_b(UPGRADES_NBT, (Object)upgradesNBT);
        this.deserializeUpgrades(upgradesNBT);
    }

    private void deserializeUpgrades(NBTTagCompound upgradesNBT) {
        for (String key : upgradesNBT.func_150296_c()) {
            ResourceLocation resourceLocation = new ResourceLocation(key);
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(resourceLocation);
            if (upgradeType == null) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.deserializeNBT(upgradesNBT.func_74775_l(key));
            this.upgrades.put(resourceLocation, upgrade);
        }
    }

    private void deserializeUpgradesData(NBTTagCompound upgradesNBT) {
        for (String key : upgradesNBT.func_150296_c()) {
            ResourceLocation resourceLocation = new ResourceLocation(key);
            if (this.upgrades.containsKey(resourceLocation)) {
                this.upgrades.get(resourceLocation).deserializeNBTData(upgradesNBT.func_74775_l(key));
                continue;
            }
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(resourceLocation);
            if (upgradeType == null) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.deserializeNBTData(upgradesNBT.func_74775_l(key));
            this.upgrades.put(resourceLocation, upgrade);
        }
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        for (ResourceLocation key : this.upgrades.keySet()) {
            if (upgradesNBT.func_150296_c().contains(key.toString())) continue;
            toRemove.add(key);
        }
        for (ResourceLocation key : toRemove) {
            this.upgrades.remove(key);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Fuel", ((Integer)this.field_70180_af.func_187225_a(FUEL)).intValue());
        compound.func_74768_a("health", ((Integer)this.field_70180_af.func_187225_a(HEALTH)).intValue());
        compound.func_74768_a("max_health", ((Integer)this.field_70180_af.func_187225_a(MAX_HEALTH)).intValue());
        compound.func_74776_a("max_speed", ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue());
        compound.func_74778_a("material", (String)this.field_70180_af.func_187225_a(MATERIAL));
        compound.func_74782_a("upgrades", (NBTBase)this.getUpgradesNBT());
    }

    private NBTTagCompound getUpgradesNBT() {
        NBTTagCompound upgradesNBT = new NBTTagCompound();
        for (Upgrade upgrade : this.upgrades.values()) {
            upgradesNBT.func_74782_a(upgrade.getType().getRegistryName().toString(), (NBTBase)upgrade.serializeNBT());
        }
        return upgradesNBT;
    }

    private NBTTagCompound getUpgradesNBTData() {
        NBTTagCompound upgradesNBT = new NBTTagCompound();
        for (Upgrade upgrade : this.upgrades.values()) {
            upgradesNBT.func_74782_a(upgrade.getType().getRegistryName().toString(), (NBTBase)upgrade.serializeNBTData());
        }
        return upgradesNBT;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return this.upgrades.containsKey(SimplePlanesUpgrades.FLOATING.getId());
    }

    public boolean func_70067_L() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return super.func_70114_g(entityIn);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (UPGRADES_NBT.equals(key) && this.field_70170_p.field_72995_K) {
            this.deserializeUpgradesData((NBTTagCompound)this.field_70180_af.func_187225_a(UPGRADES_NBT));
        }
        if (MATERIAL.equals(key) && this.field_70170_p.field_72995_K) {
            this.material = SimplePlanesMaterials.getMaterial((String)this.field_70180_af.func_187225_a(MATERIAL));
        }
        if (Q.equals(key) && this.field_70170_p.field_72995_K && !this.func_184186_bw()) {
            if (this.field_70148_d) {
                this.lerpStepsQ = 0;
                this.setQ_Client(this.getQ());
                this.setQ_prev(this.getQ());
            } else {
                this.lerpStepsQ = 10;
            }
        }
    }

    public double func_70042_X() {
        return 0.375;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.func_94541_c()) {
            return false;
        }
        if (source.func_76347_k() && this.material.fireResistant) {
            return true;
        }
        return source.func_76346_g() != null && source.func_76346_g().func_184223_x((Entity)this);
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if ((onGroundIn || this.isAboveWater()) && Config.INSTANCE.PLANE_CRASH) {
            double y1 = this.transformPos(new Vector3f(0.0f, 1.0f, 0.0f)).getY();
            if (y1 < Math.cos(Math.toRadians(this.getLandingAngle()))) {
                state.func_177230_c().func_180658_a(this.field_70170_p, pos, (Entity)this, (float)(this.getMotion().func_72433_c() * 5.0));
            }
            this.field_70143_R = 0.0f;
        }
    }

    protected int getLandingAngle() {
        return 30;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.func_184207_aI()) {
            this.crash(distance * damageMultiplier);
        }
    }

    public void crash(float damage) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            for (Entity entity : this.func_184188_bt()) {
                float damage_mod = Math.min(1.0f, 1.0f - (float)this.getHealth() / (float)this.getMaxHealth());
                entity.func_70097_a(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage * damage_mod);
            }
            this.func_70097_a(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage + 2.0f);
        }
    }

    public boolean isCreative() {
        return this.func_184179_bs() instanceof EntityPlayer && ((EntityPlayer)this.func_184179_bs()).func_184812_l_();
    }

    public boolean getOnGround() {
        return this.field_70122_E || this.groundTicks > 1;
    }

    public boolean isAboveWater() {
        return this.field_70170_p.func_180495_p(new BlockPos(this.func_174791_d().func_72441_c(0.0, 0.4, 0.0))).func_177230_c() == Blocks.field_150355_j;
    }

    public boolean canAddUpgrade(UpgradeType upgradeType) {
        return !this.upgrades.containsKey(upgradeType.getRegistryName()) && !upgradeType.occupyBackSeat && upgradeType.isPlaneApplicable(this);
    }

    public boolean isLarge() {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        boolean b;
        super.func_184232_k(passenger);
        boolean bl = b = passenger instanceof EntityPlayer && ((EntityPlayer)passenger).func_175144_cb();
        if (this.func_184196_w(passenger) && !b) {
            this.applyYawToEntity(passenger);
        }
    }

    public void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_70034_d(entityToUpdate.func_70079_am() + this.deltaRotation);
        entityToUpdate.field_70177_z += this.deltaRotation;
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        float perc = this.deltaRotationTicks > 0 ? 1.0f / (float)this.deltaRotationTicks : 1.0f;
        float diff = (f1 - f) * perc;
        entityToUpdate.field_70126_B += diff;
        entityToUpdate.field_70177_z += diff;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    public void func_184225_p(Entity passenger) {
        EntityPlayer playerEntity;
        super.func_184225_p(passenger);
        if (this.upgrades.containsKey(SimplePlanesUpgrades.FOLDING.getId()) && passenger instanceof EntityPlayer && !(playerEntity = (EntityPlayer)passenger).func_184812_l_() && this.func_184188_bt().size() == 0 && !this.field_70128_L) {
            ItemStack itemStack = this.getItemStack();
            playerEntity.func_191521_c(itemStack);
        }
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack(this.getItem());
        if (this.upgrades.containsKey(SimplePlanesUpgrades.FOLDING.getId())) {
            NBTTagCompound value = this.serializeNBT();
            value.func_74757_a("Used", true);
            itemStack.func_77983_a("EntityTag", (NBTBase)value);
        }
        return itemStack;
    }

    protected Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("simpleplanes", this.getMaterial().name + "_plane"));
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.lerpStepsQ = 0;
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.getPosX() + (this.lerpX - this.getPosX()) / (double)this.lerpSteps;
            double d1 = this.getPosY() + (this.lerpY - this.getPosY()) / (double)this.lerpSteps;
            double d2 = this.getPosZ() + (this.lerpZ - this.getPosZ()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
        }
        if (this.lerpStepsQ > 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(MathUtil.lerpQ(1.0f / (float)this.lerpStepsQ, this.getQ_Client(), this.getQ()));
            --this.lerpStepsQ;
        } else if (this.lerpStepsQ == 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(this.getQ());
            --this.lerpStepsQ;
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (x == this.getPosX() && y == this.getPosY() && z == this.getPosZ()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = 10;
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        double d0 = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        double d1 = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        this.field_70169_q = d0;
        this.field_70167_r = y;
        this.field_70166_s = d1;
        this.func_70107_b(d0, y, d1);
        this.field_70177_z = yaw % 360.0f;
        this.field_70125_A = pitch % 360.0f;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw()) {
            this.mountmassage = true;
            if (this.lerpSteps > 0) {
                this.lerpSteps = 0;
                this.func_70080_a(this.lerpX, this.lerpY, this.lerpZ, this.field_70177_z, this.field_70125_A);
            }
        }
    }

    public EntityPlayer getPlayer() {
        if (this.func_184179_bs() instanceof EntityPlayer) {
            return (EntityPlayer)this.func_184179_bs();
        }
        return null;
    }

    public void upgradeChanged() {
        this.field_70180_af.func_187227_b(UPGRADES_NBT, (Object)this.getUpgradesNBTData());
    }

    private void setRockingTicks(int rockingTicks) {
        this.field_70180_af.func_187227_b(ROCKING_TICKS, (Object)rockingTicks);
    }

    private int getRockingTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ROCKING_TICKS);
    }

    private void updateRocking() {
        if (this.field_70170_p.field_72995_K) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 0.05f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = MathHelper.func_76131_a((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_72820_D()) * this.rockingIntensity;
        } else {
            int k;
            if (!this.rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    Vec3d vector3d = this.getMotion();
                    if (this.field_203060_aN) {
                        this.setMotion(vector3d.func_72441_c(0.0, -0.7, 0.0));
                        this.func_184226_ay();
                    } else {
                        this.setMotion(vector3d.field_72450_a, this.func_184218_aH() ? 2.7 : 0.6, vector3d.field_72449_c);
                    }
                }
                this.rocking = false;
            }
        }
    }

    public float getRockingAngle(float partialTicks) {
        return MathUtil.lerp(partialTicks, this.prevRockingAngle, this.rockingAngle);
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public boolean hasChest() {
        return false;
    }

    public double getCameraDistanceMultiplayer() {
        return 1.0;
    }

    public double getPosX() {
        return this.field_70165_t;
    }

    public void setPosX(double posX) {
        this.field_70165_t = posX;
    }

    public double getPosY() {
        return this.field_70163_u;
    }

    public void setPosY(double posY) {
        this.field_70163_u = posY;
    }

    public double getPosZ() {
        return this.field_70161_v;
    }

    public void setPosZ(double posZ) {
        this.field_70161_v = posZ;
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound nbtData = new NBTTagCompound();
        this.func_70014_b(nbtData);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbtData);
    }

    public void readSpawnData(ByteBuf additionalData) {
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)additionalData);
        this.func_70037_a(compound);
    }

    protected class Vars {
        public float moveForward = 0.0f;
        public double turn_threshold = 0.0;
        public float moveStrafing = 0.0f;
        public boolean passengerSprinting;
        double max_speed = 3.0;
        double max_push_speed;
        double take_off_speed;
        float max_lift;
        double lift_factor;
        double gravity;
        double drag;
        double drag_mul;
        double drag_quad;
        float push;
        float ground_push;
        float passive_engine_push;
        float motion_to_rotation;
        float pitch_to_motion;
        float yaw_multiplayer;

        public Vars() {
            this.max_push_speed = PlaneEntity.this.getMaxSpeed() * 10.0f;
            this.take_off_speed = 0.3;
            this.max_lift = 2.0f;
            this.lift_factor = 10.0;
            this.gravity = -0.03;
            this.drag = 0.001;
            this.drag_mul = 5.0E-4;
            this.drag_quad = 0.001;
            this.push = 0.06f;
            this.ground_push = 0.01f;
            this.passive_engine_push = 0.025f;
            this.motion_to_rotation = 0.05f;
            this.pitch_to_motion = 0.2f;
            this.yaw_multiplayer = 0.2f;
        }
    }
}

