/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.DataSerializerEntry;
import xyz.przemyk.simpleplanes.math.Quaternion;

@Mod.EventBusSubscriber(modid="simpleplanes")
public class SimplePlanesDataSerializers {
    public static final DataSerializer<Quaternion> QUATERNION_SERIALIZER = new DataSerializer<Quaternion>(){

        public void write(PacketBuffer buf, Quaternion q) {
            buf.writeFloat(q.getX());
            buf.writeFloat(q.getY());
            buf.writeFloat(q.getZ());
            buf.writeFloat(q.getW());
        }

        public Quaternion read(PacketBuffer buf) {
            try {
                return new Quaternion(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("packet buffer does not contain enough data to construct plane's Quaternion", e);
            }
        }

        public DataParameter<Quaternion> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Quaternion copyValue(Quaternion q) {
            return new Quaternion(q);
        }
    };

    @SubscribeEvent
    public static void registerSerializers(RegistryEvent.Register<DataSerializerEntry> event) {
        event.getRegistry().register(new DataSerializerEntry(QUATERNION_SERIALIZER).setRegistryName("simpleplanes", "serializerQuaternion"));
    }
}

