/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.floating;

import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.math.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.floating.FloatingModel;
import xyz.przemyk.simpleplanes.upgrades.floating.HelicopterFloatingModel;
import xyz.przemyk.simpleplanes.upgrades.floating.LargeFloatingModel;

public class FloatingUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/floating.png");
    public static final ResourceLocation LARGE_TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/floating_large.png");
    public static final ResourceLocation HELICOPTER_TEXTURE = new ResourceLocation("textures/blocks/wool_colored_white.png");

    public FloatingUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.FLOATING, planeEntity);
    }

    @Override
    public boolean tick() {
        if (this.planeEntity.isAboveWater()) {
            Vec3d motion = this.planeEntity.getMotion();
            double f = 1.0;
            double y = MathUtil.lerp(1.0, motion.field_72448_b, Math.max(motion.field_72448_b, 0.0));
            this.planeEntity.setMotion(motion.field_72450_a * f, y, motion.field_72449_c * f);
            if (this.planeEntity.field_70170_p.func_180495_p(new BlockPos(this.planeEntity.func_174791_d().func_72441_c(0.0, 0.5, 0.0))).func_177230_c() == Blocks.field_150355_j) {
                this.planeEntity.setMotion(this.planeEntity.getMotion().func_72441_c(0.0, 0.04, 0.0));
            }
        }
        return false;
    }

    @Override
    public void render(float partialTicks, float scale) {
        if (this.planeEntity.isLarge()) {
            if (this.planeEntity instanceof HelicopterEntity) {
                HelicopterFloatingModel.INSTANCE.func_78088_a(this.planeEntity, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, scale);
            } else {
                LargeFloatingModel.INSTANCE.func_78088_a(this.planeEntity, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, scale);
            }
        } else {
            FloatingModel.INSTANCE.func_78088_a(this.planeEntity, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, scale);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.planeEntity.isLarge()) {
            if (this.planeEntity instanceof HelicopterEntity) {
                return HELICOPTER_TEXTURE;
            }
            return LARGE_TEXTURE;
        }
        return TEXTURE;
    }
}

