/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.rocket;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.math.MathUtil;
import xyz.przemyk.simpleplanes.math.Vector3f;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.rocket.RocketModel;

public class RocketUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/rocket.png");
    public static int FUEL_PER_GUNPOWDER = 20;
    public int fuel = 0;

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compoundNBT = new NBTTagCompound();
        compoundNBT.func_74768_a("fuel", this.fuel);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compoundNBT) {
        this.fuel = compoundNBT.func_74762_e("fuel");
    }

    public RocketUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.BOOSTER, planeEntity);
    }

    @Override
    public boolean tick() {
        this.push();
        return super.tick();
    }

    @Override
    public boolean onItemRightClick(EntityPlayer player, World world, EnumHand hand, ItemStack itemStack) {
        if (this.fuel <= 0 && itemStack.func_77973_b().equals(Items.field_151016_H)) {
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
            this.fuel = FUEL_PER_GUNPOWDER;
            this.planeEntity.addFuelMaxed(FUEL_PER_GUNPOWDER * 2);
        }
        this.push();
        return false;
    }

    private void push() {
        if (!this.planeEntity.field_70170_p.field_72995_K) {
            this.planeEntity.spawnParticle(EnumParticleTypes.FLAME, new Vector3f(-0.6f, 0.0f, -1.3f), 5);
            this.planeEntity.spawnParticle(EnumParticleTypes.FLAME, new Vector3f(0.6f, 0.0f, -1.3f), 5);
        }
        if (this.fuel < 0) {
            return;
        }
        --this.fuel;
        Vec3d m = this.planeEntity.getMotion();
        float pitch = 0.0f;
        EntityPlayer player = this.planeEntity.getPlayer();
        if (player != null) {
            if (player.field_191988_bg > 0.0f) {
                if (this.planeEntity.func_70051_ag()) {
                    pitch += 2.0f;
                }
            } else if (player.field_191988_bg < 0.0f) {
                pitch -= 2.0f;
            }
        }
        if (this.planeEntity.field_70170_p.field_73012_v.nextInt(50) == 0) {
            this.planeEntity.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
        if (this.planeEntity instanceof HelicopterEntity) {
            pitch = 0.0f;
        }
        this.planeEntity.field_70125_A += pitch;
        Vec3d motion = MathUtil.rotationToVector(this.planeEntity.field_70177_z, this.planeEntity.field_70125_A, 0.05);
        this.planeEntity.setMotion(m.func_178787_e(motion));
        if (!this.planeEntity.field_70170_p.field_72995_K) {
            this.planeEntity.spawnParticle(EnumParticleTypes.FLAME, new Vector3f(-0.6f, 0.0f, -1.3f), 5);
            this.planeEntity.spawnParticle(EnumParticleTypes.FLAME, new Vector3f(0.6f, 0.0f, -1.3f), 5);
        }
    }

    @Override
    public void render(float partialticks, float scale) {
        RocketModel.INSTANCE.func_78088_a(this.planeEntity, partialticks, 0.0f, 0.0f, 0.0f, 0.0f, scale);
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }
}

