/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.storage;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.render.BackSeatBlockModel;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public class ChestUpgrade
extends Upgrade
implements IInventoryChangedListener,
IInteractionObject {
    TileEntityChest tileEntity;
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/storage.png");
    public IInventory inventory;
    private float partialticks = 0.0f;
    private boolean open = false;
    private int size = 1;

    public ChestUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.CHEST, planeEntity);
        this.initChest();
    }

    protected void initChest() {
        IInventory inventory = this.inventory;
        this.inventory = new InventoryBasic("chest", false, this.size * 9){

            public void func_174889_b(EntityPlayer player) {
                ChestUpgrade.this.openInventory(player);
            }

            public void func_174886_c(EntityPlayer player) {
                ChestUpgrade.this.closeInventory(player);
            }
        };
        this.tileEntity = new TileEntityChest(){};
        if (inventory != null) {
            int j;
            int min_size = Math.min(inventory.func_70302_i_(), this.inventory.func_70302_i_());
            for (j = 0; j < min_size; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
            int max_size = Math.max(inventory.func_70302_i_(), this.inventory.func_70302_i_());
            while (j < max_size) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (!itemstack.func_190926_b()) {
                    this.planeEntity.entityDropItem(itemstack);
                }
                ++j;
            }
        }
    }

    public void func_76316_a(IInventory invBasic) {
    }

    @Override
    public boolean tick() {
        this.tileEntity.field_145986_n = this.tileEntity.field_145989_m;
        if (this.open && this.tileEntity.field_145989_m == 0.0f) {
            this.planeEntity.func_184185_a(SoundEvents.field_187657_V, 0.5f, this.planeEntity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (!this.open && this.tileEntity.field_145989_m > 0.0f || this.open && this.tileEntity.field_145989_m < 1.0f) {
            float prevLidAngle = this.tileEntity.field_145989_m;
            this.tileEntity.field_145989_m = this.open ? (this.tileEntity.field_145989_m += 0.01f) : (this.tileEntity.field_145989_m -= 0.01f);
            if (this.tileEntity.field_145989_m > 1.0f) {
                this.tileEntity.field_145989_m = 1.0f;
            }
            if (this.tileEntity.field_145989_m < 0.5f && prevLidAngle >= 0.5f) {
                this.planeEntity.func_184185_a(SoundEvents.field_187651_T, 0.5f, this.planeEntity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.tileEntity.field_145989_m < 0.0f) {
                this.tileEntity.field_145989_m = 0.0f;
            }
        }
        return super.tick();
    }

    public void openInventory(EntityPlayer player) {
        this.open = true;
        this.planeEntity.upgradeChanged();
    }

    public void closeInventory(EntityPlayer player) {
        this.open = false;
        this.planeEntity.upgradeChanged();
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList listnbt = nbt.func_150295_c("Items", 10);
        this.size = nbt.func_74762_e("size");
        this.initChest();
        for (int i = 0; i < listnbt.func_74745_c(); ++i) {
            NBTTagCompound compoundnbt = listnbt.func_150305_b(i);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            if (j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, new ItemStack(compoundnbt));
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("size", this.size);
        NBTTagList listnbt = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound compoundnbt = new NBTTagCompound();
            compoundnbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(compoundnbt);
            listnbt.func_74742_a((NBTBase)compoundnbt);
        }
        compound.func_74782_a("Items", (NBTBase)listnbt);
        return compound;
    }

    @Override
    public NBTTagCompound serializeNBTData() {
        NBTTagCompound compound = super.serializeNBTData();
        compound.func_74757_a("open", this.open);
        compound.func_74768_a("size", this.size);
        return compound;
    }

    @Override
    public void deserializeNBTData(NBTTagCompound nbt) {
        this.open = this.planeEntity.field_70170_p.field_72995_K ? nbt.func_74767_n("open") : false;
        this.size = nbt.func_74762_e("size");
        super.deserializeNBTData(nbt);
    }

    @Override
    public void render(float partialticks, float scale) {
        BackSeatBlockModel.renderBlock(this.planeEntity, partialticks, scale);
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerChest((IInventory)playerInventory, this.inventory, playerIn);
    }

    public String func_174875_k() {
        return "simpleplanes:chest_upgrade";
    }

    @Override
    public boolean onItemRightClick(EntityPlayer player, World world, EnumHand hand, ItemStack itemStack) {
        if (this.getType().IsThisItem(itemStack) && this.size < 6 && !this.open && !this.planeEntity.isFull()) {
            ++this.size;
            this.initChest();
            itemStack.func_190918_g(1);
            this.planeEntity.upgradeChanged();
        }
        return false;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        int i;
        NonNullList items = NonNullList.func_191196_a();
        for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            items.add((Object)itemstack);
        }
        for (i = 0; i < this.size; ++i) {
            items.add((Object)this.getType().getDrops());
        }
        return items;
    }

    @Override
    public int getSeats() {
        return this.size;
    }

    public String func_70005_c_() {
        return "plane chest";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("plane chest", new Object[0]);
    }
}

