/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device;

import com.mrcrayfish.device.DeviceConfig;
import com.mrcrayfish.device.DeviceTab;
import com.mrcrayfish.device.LaunchException;
import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.print.PrintingManager;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.core.io.task.TaskGetFiles;
import com.mrcrayfish.device.core.io.task.TaskGetMainDrive;
import com.mrcrayfish.device.core.io.task.TaskGetStructure;
import com.mrcrayfish.device.core.io.task.TaskSendAction;
import com.mrcrayfish.device.core.io.task.TaskSetupFileBrowser;
import com.mrcrayfish.device.core.network.task.TaskConnect;
import com.mrcrayfish.device.core.network.task.TaskGetDevices;
import com.mrcrayfish.device.core.network.task.TaskPing;
import com.mrcrayfish.device.core.print.task.TaskPrint;
import com.mrcrayfish.device.core.task.TaskInstallApp;
import com.mrcrayfish.device.entity.EntitySeat;
import com.mrcrayfish.device.event.BankEvents;
import com.mrcrayfish.device.event.EmailEvents;
import com.mrcrayfish.device.gui.GuiHandler;
import com.mrcrayfish.device.init.DeviceTileEntites;
import com.mrcrayfish.device.init.RegistrationHandler;
import com.mrcrayfish.device.network.PacketHandler;
import com.mrcrayfish.device.programs.ApplicationNoteStash;
import com.mrcrayfish.device.programs.ApplicationPixelPainter;
import com.mrcrayfish.device.programs.email.ApplicationEmail;
import com.mrcrayfish.device.programs.email.task.TaskCheckEmailAccount;
import com.mrcrayfish.device.programs.email.task.TaskDeleteEmail;
import com.mrcrayfish.device.programs.email.task.TaskRegisterEmailAccount;
import com.mrcrayfish.device.programs.email.task.TaskSendEmail;
import com.mrcrayfish.device.programs.email.task.TaskUpdateInbox;
import com.mrcrayfish.device.programs.email.task.TaskViewEmail;
import com.mrcrayfish.device.programs.gitweb.ApplicationGitWeb;
import com.mrcrayfish.device.programs.system.ApplicationAppStore;
import com.mrcrayfish.device.programs.system.ApplicationBank;
import com.mrcrayfish.device.programs.system.ApplicationFileBrowser;
import com.mrcrayfish.device.programs.system.ApplicationSettings;
import com.mrcrayfish.device.programs.system.task.TaskAdd;
import com.mrcrayfish.device.programs.system.task.TaskDeposit;
import com.mrcrayfish.device.programs.system.task.TaskGetBalance;
import com.mrcrayfish.device.programs.system.task.TaskPay;
import com.mrcrayfish.device.programs.system.task.TaskRemove;
import com.mrcrayfish.device.programs.system.task.TaskUpdateApplicationData;
import com.mrcrayfish.device.programs.system.task.TaskUpdateSystemData;
import com.mrcrayfish.device.programs.system.task.TaskWithdraw;
import com.mrcrayfish.device.proxy.CommonProxy;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="cdm", name="MrCrayfish's Device Mod", version="0.4.1", acceptedMinecraftVersions="[1.12.2]")
public class MrCrayfishDeviceMod {
    @Mod.Instance(value="cdm")
    public static MrCrayfishDeviceMod instance;
    @SidedProxy(clientSide="com.mrcrayfish.device.proxy.ClientProxy", serverSide="com.mrcrayfish.device.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs TAB_DEVICE;
    private static Logger logger;
    public static final boolean DEVELOPER_MODE = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws LaunchException {
        logger = event.getModLog();
        DeviceConfig.load(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)new DeviceConfig());
        RegistrationHandler.init();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        DeviceTileEntites.register();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("cdm:seat"), EntitySeat.class, (String)"Seat", (int)0, (Object)this, (int)80, (int)1, (boolean)false);
        PacketHandler.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EmailEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BankEvents());
        this.registerApplications();
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    private void registerApplications() {
        ApplicationManager.registerApplication(new ResourceLocation("cdm", "settings"), ApplicationSettings.class);
        ApplicationManager.registerApplication(new ResourceLocation("cdm", "bank"), ApplicationBank.class);
        ApplicationManager.registerApplication(new ResourceLocation("cdm", "file_browser"), ApplicationFileBrowser.class);
        ApplicationManager.registerApplication(new ResourceLocation("cdm", "gitweb"), ApplicationGitWeb.class);
        ApplicationManager.registerApplication(new ResourceLocation("cdm", "note_stash"), ApplicationNoteStash.class);
        ApplicationManager.registerApplication(new ResourceLocation("cdm", "pixel_painter"), ApplicationPixelPainter.class);
        ApplicationManager.registerApplication(new ResourceLocation("cdm", "ender_mail"), ApplicationEmail.class);
        ApplicationManager.registerApplication(new ResourceLocation("cdm", "app_store"), ApplicationAppStore.class);
        TaskManager.registerTask(TaskInstallApp.class);
        TaskManager.registerTask(TaskUpdateApplicationData.class);
        TaskManager.registerTask(TaskPrint.class);
        TaskManager.registerTask(TaskUpdateSystemData.class);
        TaskManager.registerTask(TaskConnect.class);
        TaskManager.registerTask(TaskPing.class);
        TaskManager.registerTask(TaskGetDevices.class);
        TaskManager.registerTask(TaskDeposit.class);
        TaskManager.registerTask(TaskWithdraw.class);
        TaskManager.registerTask(TaskGetBalance.class);
        TaskManager.registerTask(TaskPay.class);
        TaskManager.registerTask(TaskAdd.class);
        TaskManager.registerTask(TaskRemove.class);
        TaskManager.registerTask(TaskSendAction.class);
        TaskManager.registerTask(TaskSetupFileBrowser.class);
        TaskManager.registerTask(TaskGetFiles.class);
        TaskManager.registerTask(TaskGetStructure.class);
        TaskManager.registerTask(TaskGetMainDrive.class);
        TaskManager.registerTask(TaskUpdateInbox.class);
        TaskManager.registerTask(TaskSendEmail.class);
        TaskManager.registerTask(TaskCheckEmailAccount.class);
        TaskManager.registerTask(TaskRegisterEmailAccount.class);
        TaskManager.registerTask(TaskDeleteEmail.class);
        TaskManager.registerTask(TaskViewEmail.class);
        PrintingManager.registerPrint(new ResourceLocation("cdm", "picture"), ApplicationPixelPainter.PicturePrint.class);
    }

    public static Logger getLogger() {
        return logger;
    }

    static {
        TAB_DEVICE = new DeviceTab("cdmTabDevice");
    }
}

