/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.io;

import com.mrcrayfish.device.api.io.Drive;
import com.mrcrayfish.device.api.io.File;
import com.mrcrayfish.device.api.task.Callback;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.core.io.action.FileAction;
import com.mrcrayfish.device.core.io.task.TaskGetFiles;
import com.mrcrayfish.device.programs.system.component.FileBrowser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class Folder
extends File {
    protected List<File> files = new ArrayList<File>();
    private boolean synced = false;

    public Folder(String name) {
        this(name, false);
    }

    private Folder(String name, boolean protect) {
        this.name = name;
        this.protect = protect;
    }

    public void add(File file) {
        this.add(file, false, null);
    }

    public void add(File file, @Nullable Callback<FileSystem.Response> callback) {
        this.add(file, false, callback);
    }

    public void add(File file, boolean override, @Nullable Callback<FileSystem.Response> callback) {
        if (!this.valid) {
            throw new IllegalStateException("Folder must be added to the system before you can add files to it");
        }
        if (file == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Illegal file"), false);
            }
            return;
        }
        if (!FileSystem.PATTERN_FILE_NAME.matcher(file.name).matches()) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(5, "Invalid file name"), true);
            }
            return;
        }
        if (this.hasFile(file.name)) {
            if (!override) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(4, "A file with that name already exists"), true);
                }
                return;
            }
            if (this.getFile(file.name).isProtected()) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(3, "Unable to override protected files"), true);
                }
                return;
            }
        }
        FileSystem.sendAction(this.drive, FileAction.Factory.makeNew(this, file, override), (response, success) -> {
            if (success) {
                if (override) {
                    this.files.remove(this.getFile(file.name));
                }
                file.setDrive(this.drive);
                file.valid = true;
                file.parent = this;
                this.files.add(file);
                FileBrowser.refreshList = true;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    public void delete(String name) {
        this.delete(name, null);
    }

    public void delete(String name, @Nullable Callback<FileSystem.Response> callback) {
        this.delete(this.getFile(name), callback);
    }

    public void delete(File file) {
        this.delete(file, null);
    }

    public void delete(File file, @Nullable Callback<FileSystem.Response> callback) {
        if (!this.valid) {
            throw new IllegalStateException("Folder must be added to the system before you can delete files");
        }
        if (file == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Illegal file"), false);
            }
            return;
        }
        if (!this.files.contains(file)) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "The file does not exist in this folder"), false);
            }
            return;
        }
        if (file.isProtected()) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(3, "Cannot delete protected files"), false);
            }
            return;
        }
        FileSystem.sendAction(this.drive, FileAction.Factory.makeDelete(file), (response, success) -> {
            if (success) {
                file.drive = null;
                file.valid = false;
                file.parent = null;
                this.files.remove(file);
                FileBrowser.refreshList = true;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    public void copyInto(File file, boolean override, boolean cut, @Nullable Callback<FileSystem.Response> callback) {
        if (file == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Illegal file"), false);
            }
            return;
        }
        if (!file.valid || file.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Source file is invalid"), false);
            }
            return;
        }
        if (this.hasFile(file.name)) {
            if (!override) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(4, "A file with that name already exists"), true);
                }
                return;
            }
            if (this.getFile(file.name).isProtected()) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(3, "Unable to override protected files"), true);
                }
                return;
            }
        }
        FileSystem.sendAction(file.drive, FileAction.Factory.makeCopyCut(file, this, false, cut), (response, success) -> {
            if (response.getStatus() == 1 && file.isFolder()) {
                ((Folder)file).copy();
            }
        });
    }

    public boolean hasFile(String name) {
        return this.valid && this.files.stream().anyMatch(file -> file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public File getFile(String name) {
        return this.files.stream().filter(file -> file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public boolean hasFolder(String name) {
        return this.valid && this.files.stream().anyMatch(file -> file.isFolder() && file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public Folder getFolder(String name) {
        return this.files.stream().filter(file -> file.isFolder() && file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public void getFolder(String name, Callback<Folder> callback) {
        Folder folder = this.getFolder(name);
        if (folder == null) {
            callback.execute(null, false);
            return;
        }
        if (!folder.isSynced()) {
            TaskGetFiles task = new TaskGetFiles(folder, Laptop.getPos());
            task.setCallback((nbt, success) -> {
                if (success && nbt.func_150297_b("files", 9)) {
                    NBTTagList files = nbt.func_150295_c("files", 10);
                    folder.syncFiles(files);
                    callback.execute(folder, true);
                } else {
                    callback.execute(null, false);
                }
            });
            TaskManager.sendTask(task);
        } else {
            callback.execute(folder, true);
        }
    }

    public List<File> getFiles() {
        return this.files;
    }

    public List<File> search(Predicate<File> conditions) {
        NonNullList found = NonNullList.func_191196_a();
        this.search((List<File>)found, conditions);
        return found;
    }

    private void search(List<File> results, Predicate<File> conditions) {
        this.files.stream().forEach(file -> {
            if (conditions.test((File)file)) {
                results.add((File)file);
            }
        });
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void setData(@Nonnull NBTTagCompound data) {
    }

    @Override
    public void setData(@Nonnull NBTTagCompound data, Callback<FileSystem.Response> callback) {
        if (callback != null) {
            callback.execute(FileSystem.createResponse(0, "Can not set data of a folder"), false);
        }
    }

    @Override
    void setDrive(Drive drive) {
        this.drive = drive;
        this.files.forEach(f -> f.setDrive(drive));
    }

    public void syncFiles(NBTTagList tagList) {
        this.files.removeIf(f -> !f.isFolder());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound fileTag = tagList.func_150305_b(i);
            File file = File.fromTag(fileTag.func_74779_i("file_name"), fileTag.func_74775_l("data"));
            file.drive = this.drive;
            file.valid = true;
            file.parent = this;
            this.files.add(file);
        }
        this.synced = true;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void refresh() {
        this.synced = false;
    }

    public void validate() {
        if (!this.synced) {
            this.valid = true;
            this.files.forEach(f -> {
                if (f.isFolder()) {
                    ((Folder)f).validate();
                } else {
                    f.valid = true;
                }
            });
        }
    }

    @Override
    public NBTTagCompound toTag() {
        NBTTagCompound folderTag = new NBTTagCompound();
        NBTTagCompound fileList = new NBTTagCompound();
        this.files.stream().forEach(file -> fileList.func_74782_a(file.getName(), (NBTBase)file.toTag()));
        folderTag.func_74782_a("files", (NBTBase)fileList);
        if (this.protect) {
            folderTag.func_74757_a("protected", true);
        }
        return folderTag;
    }

    public static Folder fromTag(String name, NBTTagCompound folderTag) {
        Folder folder = new Folder(name);
        if (folderTag.func_150297_b("protected", 1)) {
            folder.protect = folderTag.func_74767_n("protected");
        }
        NBTTagCompound fileList = folderTag.func_74775_l("files");
        for (String fileName : fileList.func_150296_c()) {
            File file;
            NBTTagCompound fileTag = fileList.func_74775_l(fileName);
            if (fileTag.func_74764_b("files")) {
                file = Folder.fromTag(fileName, fileTag);
                file.parent = folder;
                folder.files.add(file);
                continue;
            }
            file = File.fromTag(fileName, fileTag);
            file.parent = folder;
            folder.files.add(file);
        }
        return folder;
    }

    @Override
    public File copy() {
        Folder folder = new Folder(this.name);
        this.files.forEach(f -> {
            File copy = f.copy();
            copy.protect = false;
            folder.files.add(copy);
        });
        return folder;
    }

    @Override
    public File copy(String newName) {
        Folder folder = new Folder(newName);
        this.files.forEach(f -> {
            File copy = f.copy();
            copy.protect = false;
            folder.files.add(copy);
        });
        return folder;
    }
}

