/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.io;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.core.io.ServerFolder;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ServerFile {
    public static final Comparator<ServerFile> SORT_BY_NAME = (f1, f2) -> {
        if (f1.isFolder() && !f2.isFolder()) {
            return -1;
        }
        if (!f1.isFolder() && f2.isFolder()) {
            return 1;
        }
        return f1.name.compareTo(f2.name);
    };
    protected ServerFolder parent;
    protected String name;
    protected String openingApp;
    protected NBTTagCompound data;
    protected boolean protect = false;

    protected ServerFile() {
    }

    public ServerFile(String name, Application app, NBTTagCompound data) {
        this(name, app.getInfo().getFormattedId(), data, false);
    }

    public ServerFile(String name, String openingAppId, NBTTagCompound data) {
        this(name, openingAppId, data, false);
    }

    private ServerFile(String name, String openingAppId, NBTTagCompound data, boolean protect) {
        this.name = name;
        this.openingApp = openingAppId;
        this.data = data;
        this.protect = protect;
    }

    public String getName() {
        return this.name;
    }

    public FileSystem.Response rename(String name) {
        if (this.protect) {
            return FileSystem.createResponse(3, "Cannot rename a protected file");
        }
        if (!FileSystem.PATTERN_FILE_NAME.matcher(name).matches()) {
            return FileSystem.createResponse(5, "Invalid file name");
        }
        this.name = name;
        return FileSystem.createSuccessResponse();
    }

    @Nullable
    public String getOpeningApp() {
        return this.openingApp;
    }

    public FileSystem.Response setData(NBTTagCompound data) {
        if (this.protect) {
            return FileSystem.createResponse(3, "Cannot set data on a protected file");
        }
        if (data == null) {
            return FileSystem.createResponse(6, "Invalid data");
        }
        this.data = data;
        return FileSystem.createSuccessResponse();
    }

    @Nullable
    public NBTTagCompound getData() {
        return this.data;
    }

    @Nullable
    public ServerFolder getParent() {
        return this.parent;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public boolean isFolder() {
        return false;
    }

    public boolean isForApplication(Application app) {
        return this.openingApp != null && this.openingApp.equals(app.getInfo().getFormattedId());
    }

    public FileSystem.Response delete() {
        if (this.protect) {
            return FileSystem.createResponse(3, "Cannot delete a protected file");
        }
        if (this.parent != null) {
            return this.parent.delete(this);
        }
        return FileSystem.createResponse(2, "Invalid file");
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("openingApp", this.openingApp);
        tag.func_74782_a("data", (NBTBase)this.data);
        return tag;
    }

    public static ServerFile fromTag(String name, NBTTagCompound tag) {
        return new ServerFile(name, tag.func_74779_i("openingApp"), tag.func_74775_l("data"));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerFile)) {
            return false;
        }
        return ((ServerFile)obj).name.equalsIgnoreCase(this.name);
    }

    public ServerFile copy() {
        return new ServerFile(this.name, this.openingApp, this.data.func_74737_b());
    }
}

