/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.io;

import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.core.io.ServerFile;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ServerFolder
extends ServerFile {
    private List<ServerFile> files = new ArrayList<ServerFile>();

    public ServerFolder(String name) {
        this(name, false);
    }

    private ServerFolder(String name, boolean protect) {
        this.name = name;
        this.protect = protect;
    }

    public FileSystem.Response add(ServerFile file, boolean override) {
        if (file == null) {
            return FileSystem.createResponse(2, "Illegal file");
        }
        if (!FileSystem.PATTERN_FILE_NAME.matcher(file.getName()).matches()) {
            return FileSystem.createResponse(5, "Invalid file name");
        }
        if (this.hasFile(file.name)) {
            if (!override) {
                return FileSystem.createResponse(4, "A file with that name already exists");
            }
            if (this.getFile(file.name).isProtected()) {
                return FileSystem.createResponse(3, "Unable to override protected files");
            }
            this.files.remove(this.getFile(file.name));
        }
        this.files.add(file);
        file.parent = this;
        return FileSystem.createSuccessResponse();
    }

    public FileSystem.Response delete(String name) {
        return this.delete(this.getFile(name));
    }

    public FileSystem.Response delete(ServerFile file) {
        if (file == null) {
            return FileSystem.createResponse(2, "Illegal file");
        }
        if (!this.files.contains(file)) {
            return FileSystem.createResponse(2, "The file does not exist in this folder");
        }
        if (file.isProtected()) {
            return FileSystem.createResponse(3, "Cannot delete protected files");
        }
        file.parent = null;
        this.files.remove(file);
        return FileSystem.createSuccessResponse();
    }

    public boolean hasFile(String name) {
        return this.files.stream().anyMatch(file -> file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public ServerFile getFile(String name) {
        return this.files.stream().filter(file -> file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public boolean hasFolder(String name) {
        return this.files.stream().anyMatch(file -> file.isFolder() && file.name.equalsIgnoreCase(name));
    }

    @Nullable
    public ServerFolder getFolder(String name) {
        return this.files.stream().filter(file -> file.isFolder() && file.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public List<ServerFile> getFiles() {
        return this.files;
    }

    public List<ServerFile> search(Predicate<ServerFile> conditions, boolean includeSubServerFolders) {
        NonNullList found = NonNullList.func_191196_a();
        this.search((List<ServerFile>)found, conditions, includeSubServerFolders);
        return found;
    }

    private void search(List<ServerFile> results, Predicate<ServerFile> conditions, boolean includeSubServerFolders) {
        this.files.stream().forEach(file -> {
            if (file.isFolder()) {
                if (includeSubServerFolders) {
                    ((ServerFolder)file).search(results, conditions, includeSubServerFolders);
                }
            } else if (conditions.test((ServerFile)file)) {
                results.add((ServerFile)file);
            }
        });
    }

    public void setFiles(List<ServerFile> files) {
        this.files = files;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public NBTTagCompound toTag() {
        NBTTagCompound folderTag = new NBTTagCompound();
        NBTTagCompound fileList = new NBTTagCompound();
        this.files.stream().forEach(file -> fileList.func_74782_a(file.getName(), (NBTBase)file.toTag()));
        folderTag.func_74782_a("files", (NBTBase)fileList);
        if (this.protect) {
            folderTag.func_74757_a("protected", true);
        }
        return folderTag;
    }

    public static ServerFolder fromTag(String name, NBTTagCompound folderTag) {
        ServerFolder folder = new ServerFolder(name);
        if (folderTag.func_150297_b("protected", 1)) {
            folder.protect = folderTag.func_74767_n("protected");
        }
        NBTTagCompound fileList = folderTag.func_74775_l("files");
        for (String fileName : fileList.func_150296_c()) {
            NBTTagCompound fileTag = fileList.func_74775_l(fileName);
            if (fileTag.func_74764_b("files")) {
                folder.add(ServerFolder.fromTag(fileName, fileTag), false);
                continue;
            }
            folder.add(ServerFile.fromTag(fileName, fileTag), false);
        }
        return folder;
    }

    @Override
    public FileSystem.Response setData(@Nonnull NBTTagCompound data) {
        return FileSystem.createResponse(6, "Data can not be set to a folder");
    }

    @Override
    public ServerFile copy() {
        ServerFolder folder = new ServerFolder(this.name);
        this.files.forEach(f -> {
            ServerFile copy = f.copy();
            copy.protect = false;
            folder.add(copy, false);
        });
        return folder;
    }

    public ServerFolder copyStructure() {
        ServerFolder folder = new ServerFolder(this.name, this.protect);
        this.files.forEach(f -> {
            if (f.isFolder()) {
                folder.add(((ServerFolder)f).copyStructure(), false);
            }
        });
        return folder;
    }
}

