/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.task;

import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.tileentity.TileEntityLaptop;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskInstallApp
extends Task {
    private String appId;
    private BlockPos laptopPos;
    private boolean install;

    private TaskInstallApp() {
        super("install_app");
    }

    public TaskInstallApp(AppInfo info, BlockPos laptopPos, boolean install) {
        this();
        this.appId = info.getFormattedId();
        this.laptopPos = laptopPos;
        this.install = install;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74778_a("appId", this.appId);
        nbt.func_74772_a("pos", this.laptopPos.func_177986_g());
        nbt.func_74757_a("install", this.install);
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        String appId = nbt.func_74779_i("appId");
        TileEntity tileEntity = world.func_175625_s(BlockPos.func_177969_a((long)nbt.func_74763_f("pos")));
        if (tileEntity instanceof TileEntityLaptop) {
            TileEntityLaptop laptop = (TileEntityLaptop)tileEntity;
            NBTTagCompound systemData = laptop.getSystemData();
            NBTTagList tagList = systemData.func_150295_c("InstalledApps", 8);
            if (nbt.func_74767_n("install")) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    if (!tagList.func_150307_f(i).equals(appId)) continue;
                    return;
                }
                tagList.func_74742_a((NBTBase)new NBTTagString(appId));
                this.setSuccessful();
            } else {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    if (!tagList.func_150307_f(i).equals(appId)) continue;
                    tagList.func_74744_a(i);
                    this.setSuccessful();
                }
            }
            systemData.func_74782_a("InstalledApps", (NBTBase)tagList);
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
    }
}

