/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.init;

import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.init.DeviceBlocks;
import com.mrcrayfish.device.init.DeviceCrafting;
import com.mrcrayfish.device.init.DeviceItems;
import com.mrcrayfish.device.item.SubItems;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistrationHandler {
    public static void init() {
        DeviceBlocks.register();
        DeviceItems.register();
        DeviceCrafting.register();
    }

    @Mod.EventBusSubscriber(modid="cdm", value={Side.CLIENT})
    public static class Models {
        @SubscribeEvent
        public static void register(ModelRegistryEvent event) {
            MrCrayfishDeviceMod.getLogger().info("Registering models");
            Items.ITEMS.forEach(Models::registerRender);
        }

        private static void registerRender(Item item) {
            if (item instanceof SubItems) {
                NonNullList<ResourceLocation> modelLocations = ((SubItems)item).getModels();
                for (int i = 0; i < modelLocations.size(); ++i) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation((ResourceLocation)modelLocations.get(i), "inventory"));
                }
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("cdm:" + item.func_77658_a().substring(5), "inventory"));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="cdm")
    public static class Recipes {
        private static final List<IRecipe> RECIPES = new LinkedList<IRecipe>();

        static void add(IRecipe recipe) {
            RECIPES.add(recipe);
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<IRecipe> event) {
            MrCrayfishDeviceMod.getLogger().info("Registering recipes");
            RECIPES.forEach(recipe -> event.getRegistry().register((IForgeRegistryEntry)recipe));
        }
    }

    @Mod.EventBusSubscriber(modid="cdm")
    public static class Items {
        private static final List<Item> ITEMS = new LinkedList<Item>();

        static void add(Item item) {
            ITEMS.add(item);
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Item> event) {
            MrCrayfishDeviceMod.getLogger().info("Registering items");
            ITEMS.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
        }
    }

    @Mod.EventBusSubscriber(modid="cdm")
    public static class Blocks {
        private static final List<Block> BLOCKS = new LinkedList<Block>();

        static void add(Block block) {
            BLOCKS.add(block);
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Block> event) {
            MrCrayfishDeviceMod.getLogger().info("Registering blocks");
            BLOCKS.forEach(block -> event.getRegistry().register((IForgeRegistryEntry)block));
        }
    }
}

