/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.object.tiles;

import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.object.Game;
import com.mrcrayfish.device.object.tiles.Tile;
import org.lwjgl.opengl.GL11;

public class TileBlock
extends Tile {
    public TileBlock(int id, int x, int y) {
        super(id, x, y);
    }

    public TileBlock(int id, int x, int y, int topX, int topY) {
        super(id, x, y, topX, topY);
    }

    @Override
    public void render(Game game, int x, int y, Game.Layer layer) {
        if (layer == Game.Layer.BACKGROUND) {
            super.render(game, x, y, layer);
            if (!game.isFullTile(layer, x, y + 1) && this != Tile.water) {
                GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
                RenderUtil.drawRectWithTexture(game.xPosition + x * 8, game.yPosition + y * 6 + 6, layer.zLevel, this.x * 16, this.y * 16, 8, 2, 16.0f, 4.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            return;
        }
        if (game.getTile(layer.up(), x, y - 1) != this || layer == Game.Layer.FOREGROUND) {
            RenderUtil.drawRectWithTexture(game.xPosition + x * 8, game.yPosition + y * 6 - 6, layer.zLevel, this.topX * 16, this.topY * 16, 8, 6, 16.0f, 16.0f);
        }
        GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        RenderUtil.drawRectWithTexture(game.xPosition + x * 8, game.yPosition + y * 6, layer.zLevel, this.x * 16, this.y * 16, 8, 6, 16.0f, 16.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderForeground(Game game, int x, int y, Game.Layer layer) {
        if (layer != Game.Layer.BACKGROUND || this == Tile.water) {
            return;
        }
        Tile tileDown = game.getTile(layer, x, y + 1);
        if (game.getTile(layer, x, y + 1) == Tile.water) {
            GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
            RenderUtil.drawRectWithTexture(game.xPosition + x * 8, game.yPosition + y * 6 + 6, layer.zLevel, this.x * 16, this.y * 16, 8, 1, 16.0f, 2.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

