/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.auction.object;

import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AuctionItem {
    private UUID id;
    private ItemStack stack;
    private int price;
    private long timeLeft;
    private UUID sellerId;

    public AuctionItem(ItemStack stack, int price, long timeLeft, UUID sellerId) {
        this.id = UUID.randomUUID();
        this.stack = stack;
        this.price = price;
        this.timeLeft = timeLeft;
        this.sellerId = sellerId;
    }

    public AuctionItem(UUID id, ItemStack stack, int price, long timeLeft, UUID sellerId) {
        this.id = id;
        this.stack = stack;
        this.price = price;
        this.timeLeft = timeLeft;
        this.sellerId = sellerId;
    }

    public UUID getId() {
        return this.id;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getPrice() {
        return this.price;
    }

    public UUID getSellerId() {
        return this.sellerId;
    }

    public boolean isValid() {
        return this.timeLeft > 0L;
    }

    public void decrementTime() {
        if (this.timeLeft > 0L) {
            --this.timeLeft;
        }
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public void setSold() {
        this.timeLeft = 0L;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("id", this.id.toString());
        NBTTagCompound item = new NBTTagCompound();
        this.stack.func_77955_b(item);
        tag.func_74782_a("item", (NBTBase)item);
        tag.func_74768_a("price", this.price);
        tag.func_74772_a("time", this.timeLeft);
        tag.func_74778_a("seller", this.sellerId.toString());
    }

    public static AuctionItem readFromNBT(NBTTagCompound tag) {
        UUID id = UUID.fromString(tag.func_74779_i("id"));
        NBTTagCompound item = tag.func_74775_l("item");
        ItemStack stack = new ItemStack(item);
        int price = tag.func_74762_e("price");
        long timeLeft = tag.func_74763_f("time");
        UUID sellerId = UUID.fromString(tag.func_74779_i("seller"));
        return new AuctionItem(id, stack, price, timeLeft, sellerId);
    }

    public String toString() {
        return "{ " + this.id + ", " + this.stack + ", " + this.price + ", " + this.timeLeft + ", " + this.sellerId + " }";
    }
}

