/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.gitweb.component.container;

import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.programs.gitweb.component.container.ContainerBox;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class FurnaceBox
extends ContainerBox {
    public static final int HEIGHT = 68;
    private int progressTimer;
    private int fuelTimer;
    private int fuelTime;

    public FurnaceBox(ItemStack input, ItemStack fuel, ItemStack result) {
        super(0, 0, 0, 68, 68, new ItemStack(Blocks.field_150460_al), "Furnace");
        this.slots.add(new ContainerBox.Slot(26, 8, input));
        this.slots.add(new ContainerBox.Slot(26, 44, fuel));
        this.slots.add(new ContainerBox.Slot(85, 26, result));
        this.fuelTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
    }

    @Override
    protected void handleTick() {
        if (++this.progressTimer == 200) {
            this.progressTimer = 0;
        }
        if (--this.fuelTimer <= 0) {
            this.fuelTimer = this.fuelTime;
        }
    }

    @Override
    protected void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        super.render(laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        mc.func_110434_K().func_110577_a(CONTAINER_BOXES_TEXTURE);
        int burnProgress = this.getBurnLeftScaled(13);
        this.func_73729_b(x + 26, y + 52 - burnProgress, 128, 238 - burnProgress, 14, burnProgress + 1);
        int cookProgress = this.getCookProgressScaled(24);
        this.func_73729_b(x + 49, y + 37, 128, 239, cookProgress + 1, 16);
    }

    private int getCookProgressScaled(int pixels) {
        return this.progressTimer * pixels / 200;
    }

    private int getBurnLeftScaled(int pixels) {
        int i = this.fuelTime;
        if (i == 0) {
            i = 200;
        }
        return this.fuelTimer * pixels / i + 1;
    }
}

