/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system;

import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.CheckBox;
import com.mrcrayfish.device.api.app.component.ComboBox;
import com.mrcrayfish.device.api.app.renderer.ItemRenderer;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.Settings;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.object.TrayItem;
import com.mrcrayfish.device.programs.system.SystemApplication;
import com.mrcrayfish.device.programs.system.component.Palette;
import com.mrcrayfish.device.programs.system.object.ColorScheme;
import java.awt.Color;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ApplicationSettings
extends SystemApplication {
    private Button buttonPrevious;
    private Layout layoutMain;
    private Layout layoutGeneral;
    private CheckBox checkBoxShowApps;
    private Layout layoutPersonalise;
    private Button buttonWallpaperLeft;
    private Button buttonWallpaperRight;
    private Button buttonWallpaperUrl;
    private Layout layoutColorScheme;
    private Button buttonColorSchemeApply;
    private Stack<Layout> predecessor = new Stack();

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.buttonPrevious = new Button(2, 2, Icons.ARROW_LEFT);
        this.buttonPrevious.setVisible(false);
        this.buttonPrevious.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (this.predecessor.size() > 0) {
                    this.setCurrentLayout(this.predecessor.pop());
                }
                if (this.predecessor.isEmpty()) {
                    this.buttonPrevious.setVisible(false);
                }
            }
        });
        this.layoutMain = new Menu("Home");
        Button buttonColorScheme = new Button(5, 26, "Personalise", Icons.EDIT);
        buttonColorScheme.setSize(90, 20);
        buttonColorScheme.setToolTip("Personalise", "Change the wallpaper, UI colors, and more!");
        buttonColorScheme.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.showMenu(this.layoutPersonalise);
            }
        });
        this.layoutMain.addComponent(buttonColorScheme);
        this.layoutGeneral = new Menu("General");
        this.layoutGeneral.addComponent(this.buttonPrevious);
        this.checkBoxShowApps = new CheckBox("Show All Apps", 5, 5);
        this.checkBoxShowApps.setSelected(Settings.isShowAllApps());
        this.checkBoxShowApps.setClickListener((mouseX, mouseY, mouseButton) -> {
            Settings.setShowAllApps(this.checkBoxShowApps.isSelected());
            Laptop laptop = this.getLaptop();
            laptop.getTaskBar().setupApplications(laptop.getApplications());
        });
        this.layoutGeneral.addComponent(this.checkBoxShowApps);
        this.layoutPersonalise = new Menu("Personalise");
        this.layoutPersonalise.addComponent(this.buttonPrevious);
        this.layoutPersonalise.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            int wallpaperX = 7;
            int wallpaperY = 28;
            Gui.func_73734_a((int)(x + wallpaperX - 1), (int)(y + wallpaperY - 1), (int)(x + wallpaperX - 1 + 122), (int)(y + wallpaperY - 1 + 70), (int)this.getLaptop().getSettings().getColorScheme().getHeaderColor());
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            List<ResourceLocation> wallpapers = this.getLaptop().getWallapapers();
            mc.func_110434_K().func_110577_a(wallpapers.get(this.getLaptop().getCurrentWallpaper()));
            RenderUtil.drawRectWithFullTexture(x + wallpaperX, y + wallpaperY, 0.0f, 0.0f, 120, 68);
            mc.field_71466_p.func_175065_a("Wallpaper", (float)(x + wallpaperX + 3), (float)(y + wallpaperY + 3), this.getLaptop().getSettings().getColorScheme().getTextColor(), true);
        });
        this.buttonWallpaperLeft = new Button(135, 27, Icons.ARROW_LEFT);
        this.buttonWallpaperLeft.setSize(25, 20);
        this.buttonWallpaperLeft.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Laptop laptop = this.getLaptop();
            if (laptop != null) {
                laptop.prevWallpaper();
            }
        });
        this.layoutPersonalise.addComponent(this.buttonWallpaperLeft);
        this.buttonWallpaperRight = new Button(165, 27, Icons.ARROW_RIGHT);
        this.buttonWallpaperRight.setSize(25, 20);
        this.buttonWallpaperRight.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Laptop laptop = this.getLaptop();
            if (laptop != null) {
                laptop.nextWallpaper();
            }
        });
        this.layoutPersonalise.addComponent(this.buttonWallpaperRight);
        this.buttonWallpaperUrl = new Button(135, 52, "Load", Icons.EARTH);
        this.buttonWallpaperUrl.setSize(55, 20);
        this.buttonWallpaperUrl.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Dialog.Message dialog = new Dialog.Message("This feature has not be added yet!");
            this.openDialog(dialog);
        });
        this.layoutPersonalise.addComponent(this.buttonWallpaperUrl);
        Button buttonReset = new Button(6, 100, "Reset Color Scheme");
        buttonReset.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                Laptop.getSystem().getSettings().getColorScheme().resetDefault();
            }
        });
        this.layoutPersonalise.addComponent(buttonReset);
        this.layoutColorScheme = new Menu("UI Colors");
        this.layoutPersonalise.addComponent(this.buttonPrevious);
        ComboBox.Custom<Integer> comboBoxTextColor = this.createColorPicker(145, 26);
        this.layoutColorScheme.addComponent(comboBoxTextColor);
        ComboBox.Custom<Integer> comboBoxTextSecondaryColor = this.createColorPicker(145, 44);
        this.layoutColorScheme.addComponent(comboBoxTextSecondaryColor);
        ComboBox.Custom<Integer> comboBoxHeaderColor = this.createColorPicker(145, 62);
        this.layoutColorScheme.addComponent(comboBoxHeaderColor);
        ComboBox.Custom<Integer> comboBoxBackgroundColor = this.createColorPicker(145, 80);
        this.layoutColorScheme.addComponent(comboBoxBackgroundColor);
        ComboBox.Custom<Integer> comboBoxBackgroundSecondaryColor = this.createColorPicker(145, 98);
        this.layoutColorScheme.addComponent(comboBoxBackgroundSecondaryColor);
        ComboBox.Custom<Integer> comboBoxItemBackgroundColor = this.createColorPicker(145, 116);
        this.layoutColorScheme.addComponent(comboBoxItemBackgroundColor);
        ComboBox.Custom<Integer> comboBoxItemHighlightColor = this.createColorPicker(145, 134);
        this.layoutColorScheme.addComponent(comboBoxItemHighlightColor);
        this.buttonColorSchemeApply = new Button(5, 79, Icons.CHECK);
        this.buttonColorSchemeApply.setEnabled(false);
        this.buttonColorSchemeApply.setToolTip("Apply", "Set these colors as the new color scheme");
        this.buttonColorSchemeApply.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                ColorScheme colorScheme = Laptop.getSystem().getSettings().getColorScheme();
                colorScheme.setBackgroundColor((Integer)comboBoxHeaderColor.getValue());
                this.buttonColorSchemeApply.setEnabled(false);
            }
        });
        this.layoutColorScheme.addComponent(this.buttonColorSchemeApply);
        this.setCurrentLayout(this.layoutMain);
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
    }

    private void showMenu(Layout layout) {
        this.predecessor.push(this.getCurrentLayout());
        this.buttonPrevious.setVisible(true);
        this.setCurrentLayout(layout);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.predecessor.clear();
    }

    public ComboBox.Custom<Integer> createColorPicker(int left, int top) {
        ComboBox.Custom<Integer> colorPicker = new ComboBox.Custom<Integer>(left, top, 50, 100, 100);
        colorPicker.setValue(Color.RED.getRGB());
        colorPicker.setItemRenderer(new ItemRenderer<Integer>(){

            @Override
            public void render(Integer integer, Gui gui, Minecraft mc, int x, int y, int width, int height) {
                if (integer != null) {
                    Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)integer);
                }
            }
        });
        colorPicker.setChangeListener((oldValue, newValue) -> this.buttonColorSchemeApply.setEnabled(true));
        Palette palette = new Palette(5, 5, colorPicker);
        Layout.Context layout = colorPicker.getLayout();
        layout.addComponent(palette);
        return colorPicker;
    }

    public static class SettingsTrayItem
    extends TrayItem {
        public SettingsTrayItem() {
            super(Icons.WRENCH);
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            AppInfo info = ApplicationManager.getApplication("cdm:settings");
            if (info != null) {
                Laptop.getSystem().openApplication(info);
            }
        }
    }

    private static class Menu
    extends Layout {
        private String title;

        public Menu(String title) {
            super(200, 150);
            this.title = title;
        }

        @Override
        public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
            Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getHeaderColor());
            Gui.func_73734_a((int)x, (int)y, (int)(x + this.width), (int)(y + 20), (int)color.getRGB());
            Gui.func_73734_a((int)x, (int)(y + 20), (int)(x + this.width), (int)(y + 21), (int)color.darker().getRGB());
            mc.field_71466_p.func_175065_a(this.title, (float)(x + 22), (float)(y + 6), Color.WHITE.getRGB(), true);
            super.render(laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        }
    }
}

