/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.util;

import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GLHelper {
    public static Stack<Scissor> scissorStack = new Stack();

    public static void pushScissor(int x, int y, int width, int height) {
        if (scissorStack.size() > 0) {
            Scissor scissor = scissorStack.peek();
            x = Math.max(scissor.x, x);
            y = Math.max(scissor.y, y);
            width = x + width > scissor.x + scissor.width ? scissor.x + scissor.width - x : width;
            height = y + height > scissor.y + scissor.height ? scissor.y + scissor.height - y : height;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        int scale = resolution.func_78325_e();
        GL11.glScissor((int)(x * scale), (int)(mc.field_71440_d - y * scale - height * scale), (int)Math.max(0, width * scale), (int)Math.max(0, height * scale));
        scissorStack.push(new Scissor(x, y, width, height));
    }

    public static void popScissor() {
        if (!scissorStack.isEmpty()) {
            scissorStack.pop();
        }
        GLHelper.restoreScissor();
    }

    private static void restoreScissor() {
        if (!scissorStack.isEmpty()) {
            Scissor scissor = scissorStack.peek();
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution resolution = new ScaledResolution(mc);
            int scale = resolution.func_78325_e();
            GL11.glScissor((int)(scissor.x * scale), (int)(mc.field_71440_d - scissor.y * scale - scissor.height * scale), (int)Math.max(0, scissor.width * scale), (int)Math.max(0, scissor.height * scale));
        }
    }

    public static boolean isScissorStackEmpty() {
        return scissorStack.isEmpty();
    }

    public static void clearScissorStack() {
        scissorStack.clear();
    }

    public static Color getPixel(int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        int scale = resolution.func_78325_e();
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)3);
        GL11.glReadPixels((int)(x * scale), (int)(mc.field_71440_d - y * scale - scale), (int)1, (int)1, (int)6407, (int)5126, (FloatBuffer)buffer);
        return new Color(buffer.get(0), buffer.get(1), buffer.get(2));
    }

    public static class Scissor {
        public int x;
        public int y;
        public int width;
        public int height;

        Scissor(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

