/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.axiom.databind.ser.std;

import com.fasterxml.jackson.axiom.core.JsonGenerator;
import com.fasterxml.jackson.axiom.databind.JavaType;
import com.fasterxml.jackson.axiom.databind.JsonMappingException;
import com.fasterxml.jackson.axiom.databind.JsonNode;
import com.fasterxml.jackson.axiom.databind.SerializerProvider;
import com.fasterxml.jackson.axiom.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.axiom.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.axiom.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.axiom.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public final class StringSerializer
extends StdScalarSerializer<Object> {
    private static final long serialVersionUID = 1L;

    public StringSerializer() {
        super(String.class, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        String str = (String)value;
        return str.isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

