/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.annotations;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.annotations.AnnotationUpdateAction;
import com.moulberry.axiom.annotations.data.AnnotationData;
import com.moulberry.axiom.packets.AxiomClientboundAnnotationUpdate;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ServerAnnotations
extends class_18 {
    private final LinkedHashMap<UUID, AnnotationData> annotations = new LinkedHashMap();

    private static ServerAnnotations read(class_2487 tag) {
        ServerAnnotations serverAnnotations = new ServerAnnotations();
        for (String key : tag.method_10541()) {
            try {
                UUID uuid = UUID.fromString(key);
                byte[] bytes = VersionUtilsNbt.helperCompoundTagGetByteArray(tag, key).get();
                AnnotationData annotation = AnnotationData.read(new class_2540(Unpooled.wrappedBuffer((byte[])bytes)));
                serverAnnotations.annotations.put(uuid, annotation);
            }
            catch (Exception e) {
                Axiom.LOGGER.error("Error reading annotation", e);
            }
        }
        return serverAnnotations;
    }

    public class_2487 method_75(class_2487 compoundTag) {
        class_2540 friendlyByteBuf = new class_2540(Unpooled.buffer());
        for (Map.Entry<UUID, AnnotationData> entry : this.annotations.entrySet()) {
            try {
                friendlyByteBuf.writerIndex(0);
                entry.getValue().write(friendlyByteBuf);
                byte[] bytes = new byte[friendlyByteBuf.writerIndex()];
                friendlyByteBuf.getBytes(0, bytes);
                compoundTag.method_10570(entry.getKey().toString(), bytes);
            }
            catch (Exception e) {
                Axiom.LOGGER.error("Error writing annotation", e);
            }
        }
        return compoundTag;
    }

    public static void sendAll(class_3218 serverLevel, class_3222 player) {
        ServerAnnotations serverAnnotations = (ServerAnnotations)serverLevel.method_14178().method_17981().method_20786(ServerAnnotations::read, "axiom_annotations");
        ArrayList<AnnotationUpdateAction> actions = new ArrayList<AnnotationUpdateAction>();
        actions.add(new AnnotationUpdateAction.ClearAllAnnotations());
        if (serverAnnotations != null) {
            for (Map.Entry<UUID, AnnotationData> entry : serverAnnotations.annotations.entrySet()) {
                actions.add(new AnnotationUpdateAction.CreateAnnotation(entry.getKey(), entry.getValue()));
            }
        }
        new AxiomClientboundAnnotationUpdate(actions).send(player);
    }

    public static void handleUpdates(class_3218 serverLevel, List<AnnotationUpdateAction> actions) {
        ServerAnnotations serverAnnotations = (ServerAnnotations)serverLevel.method_14178().method_17981().method_17924(ServerAnnotations::read, ServerAnnotations::new, "axiom_annotations");
        for (AnnotationUpdateAction action : actions) {
            AnnotationData annotation;
            if (action instanceof AnnotationUpdateAction.CreateAnnotation) {
                AnnotationUpdateAction.CreateAnnotation create = (AnnotationUpdateAction.CreateAnnotation)action;
                serverAnnotations.annotations.put(create.uuid(), create.annotationData());
                serverAnnotations.method_80();
                continue;
            }
            if (action instanceof AnnotationUpdateAction.DeleteAnnotation) {
                AnnotationUpdateAction.DeleteAnnotation delete = (AnnotationUpdateAction.DeleteAnnotation)action;
                AnnotationData removed = (AnnotationData)serverAnnotations.annotations.remove(delete.uuid());
                if (removed == null) continue;
                serverAnnotations.method_80();
                continue;
            }
            if (action instanceof AnnotationUpdateAction.MoveAnnotation) {
                AnnotationUpdateAction.MoveAnnotation move = (AnnotationUpdateAction.MoveAnnotation)action;
                annotation = serverAnnotations.annotations.get(move.uuid());
                if (annotation == null) continue;
                annotation.setPosition(move.to());
                serverAnnotations.method_80();
                continue;
            }
            if (action instanceof AnnotationUpdateAction.ClearAllAnnotations) {
                if (serverAnnotations.annotations.isEmpty()) continue;
                serverAnnotations.annotations.clear();
                serverAnnotations.method_80();
                continue;
            }
            if (action instanceof AnnotationUpdateAction.RotateAnnotation) {
                AnnotationUpdateAction.RotateAnnotation rotate = (AnnotationUpdateAction.RotateAnnotation)action;
                annotation = serverAnnotations.annotations.get(rotate.uuid());
                if (annotation == null) continue;
                annotation.setRotation(rotate.to());
                serverAnnotations.method_80();
                continue;
            }
            throw new UnsupportedOperationException("Unknown action: " + String.valueOf(action.getClass()));
        }
        AxiomClientboundAnnotationUpdate packet = new AxiomClientboundAnnotationUpdate(actions);
        for (class_3222 player : serverLevel.method_18456()) {
            if (!Axiom.getInstance().hasPermission((class_1657)player)) continue;
            packet.send(player);
        }
    }
}

