/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.ModifySelection;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.windows.MainMenuBar;
import com.moulberry.axiom.editor.windows.RotatePlacementWindow;
import com.moulberry.axiom.editor.windows.operations.QuickFillWindow;
import com.moulberry.axiom.editor.windows.operations.QuickReplaceWindow;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.tools.ToolManager;
import imgui.ImGui;
import imgui.type.ImBoolean;
import net.minecraft.class_2350;

public class PlacementOptionsOverlay {
    public static void render(int x, int y) {
        if (ModifySelection.isModifyingSelection()) {
            PlacementOptionsOverlay.renderModifySelection(x, y);
        } else if (Placement.INSTANCE.isPlacing()) {
            PlacementOptionsOverlay.renderPlacement(x, y);
        } else if (!Selection.getSelectionBuffer().isEmpty()) {
            PlacementOptionsOverlay.renderSelection(x, y);
        }
    }

    private static void renderPlacement(int x, int y) {
        ImGui.setNextWindowPos(x - 10, y + 10, 1, 1.0f, 0.0f);
        ImBoolean open = new ImBoolean(true);
        String title = AxiomI18n.get("axiom.editorui.window.clipboard.placement_options");
        if (ImGui.begin(title, open, 2101572)) {
            if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.keep_existing"), Placement.INSTANCE.keepExisting)) {
                Placement.INSTANCE.keepExisting = !Placement.INSTANCE.keepExisting;
            }
            ImGui.sameLine();
            if (ImGui.checkbox("Merge Blocks", Placement.INSTANCE.prioritizeFullBlocks)) {
                boolean bl = Placement.INSTANCE.prioritizeFullBlocks = !Placement.INSTANCE.prioritizeFullBlocks;
            }
            if (Placement.INSTANCE.keepExisting) {
                ImGuiHelper.tooltip("Merges new blocks with existing blocks based on block shape:\nIf the new block completely overlaps the old block, the new block is used\nOtherwise, the old block is used\n(Inverts if Keep Existing is disabled)");
            } else {
                ImGuiHelper.tooltip("Merges new blocks with existing blocks based on block shape:\nIf the old block completely overlaps the new block, the old block is used\nOtherwise, the new block is used\n(Inverts if Keep Existing is enabled)");
            }
            if (!Placement.INSTANCE.containsAir) {
                ImGui.beginDisabled();
                ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.paste_air"), false);
                ImGui.endDisabled();
                ImGuiHelper.tooltip("Placement does not contain any Air blocks\nIf you wanted to copy air, try \"Copy With Air\"", 512);
            } else if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.paste_air"), Placement.INSTANCE.pasteAir)) {
                Placement.INSTANCE.pasteAir = !Placement.INSTANCE.pasteAir;
            }
            ImGui.sameLine();
            if (Placement.INSTANCE.entities == null || Placement.INSTANCE.entities.isEmpty()) {
                ImGui.beginDisabled();
                ImGui.checkbox("Paste Entities", false);
                ImGui.endDisabled();
                ImGuiHelper.tooltip("Placement does not contain any entities\nIf you wanted to copy entities, try \"Copy With Entities\"", 512);
            } else if (ImGui.checkbox("Paste Entities", Placement.INSTANCE.pasteEntities)) {
                boolean bl = Placement.INSTANCE.pasteEntities = !Placement.INSTANCE.pasteEntities;
            }
            if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.unlock_rotation"), Placement.INSTANCE.unlockRotation)) {
                boolean bl = Placement.INSTANCE.unlockRotation = !Placement.INSTANCE.unlockRotation;
                if (Placement.INSTANCE.unlockRotation && Configuration.internal.showNon90DegreeRotationWarning) {
                    ImGui.openPopup("###RotationWarning");
                }
            }
            ImGuiHelper.tooltip("Allows for rotation by angles less than 90 degrees");
            if (ImGuiHelper.beginPopupModal(AxiomI18n.get("axiom.editorui.window.clipboard.warning_title") + "###RotationWarning", 68)) {
                ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.warning_1"));
                ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.warning_2"));
                if (ImGui.button(AxiomI18n.get("axiom.editorui.warning_confirmation"))) {
                    Configuration.internal.showNon90DegreeRotationWarning = false;
                    ImGui.closeCurrentPopup();
                }
                ImGui.endPopup();
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.rotate_scale"))) {
                RotatePlacementWindow.reset();
                EditorWindowType.ROTATE_PLACEMENT.setOpen(true);
            }
            ImGui.sameLine();
            if (ImGui.button("Flip...")) {
                ImGui.openPopup("##FlipOptions");
            }
            if (ImGui.beginPopup("##FlipOptions")) {
                if (ImGui.menuItem("Flip X")) {
                    Placement.INSTANCE.flip(class_2350.class_2351.field_11048);
                    ImGui.closeCurrentPopup();
                }
                if (ImGui.menuItem("Flip Y")) {
                    Placement.INSTANCE.flip(class_2350.class_2351.field_11052);
                    ImGui.closeCurrentPopup();
                }
                if (ImGui.menuItem("Flip Z")) {
                    Placement.INSTANCE.flip(class_2350.class_2351.field_11051);
                    ImGui.closeCurrentPopup();
                }
                ImGui.endPopup();
            }
            if (ImGui.button("Snap to ground")) {
                Placement.INSTANCE.snapToGround();
            }
            ImGui.sameLine();
            if (ImGui.button("Paste (" + Keybinds.CONFIRM.longKeyIdentifier() + ")")) {
                Placement.INSTANCE.pastePlacement();
            }
            if (ImGui.button("Paste Copy")) {
                Placement.INSTANCE.pastePlacementWithoutStopping(false);
            }
            ImGui.sameLine();
            Object pasteAndSelect = AxiomI18n.get("axiom.keybinds.paste_and_select");
            if (Keybinds.PASTE_AND_SELECT.getKey() != 0) {
                pasteAndSelect = (String)pasteAndSelect + " (" + Keybinds.PASTE_AND_SELECT.longKeyIdentifier() + ")";
            }
            if (ImGui.button((String)pasteAndSelect)) {
                Placement.INSTANCE.pastePlacement(true);
            }
        }
        ImGui.end();
        if (!open.get()) {
            Placement.INSTANCE.stopPlacement();
        }
    }

    private static void renderSelection(int x, int y) {
        ImGui.setNextWindowPos(x - 10, y + 10, 1, 1.0f, 0.0f);
        ImBoolean open = new ImBoolean(true);
        String title = "Selection Options";
        if (ImGui.begin(title, open, 2101572)) {
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.clear_selection", Keybinds.CONFIRM.longKeyIdentifier()))) {
                Selection.clearSelection();
            }
            if (ImGui.button("Move Selection")) {
                ModifySelection.start();
            }
            ImGui.separator();
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.fill_selection", Keybinds.QUICK_FILL.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                QuickFillWindow.openQuickFillWindow = true;
            }
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.replace_selection", Keybinds.QUICK_REPLACE.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                QuickReplaceWindow.openQuickReplaceWindow = true;
            }
            ImGui.separator();
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.copy_selection", Keybinds.COPY.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                Selection.callAction(UserAction.COPY, null);
            }
            ImGui.sameLine();
            if (ImGui.button("Copy With...")) {
                ImGui.openPopup("##CopyWithExtra");
            }
            if (ImGuiHelper.beginPopup("##CopyWithExtra")) {
                if (ImGui.menuItem("Copy With Air")) {
                    Selection.callCopy(true, false);
                }
                if (!ClientEvents.serverSupportsProtocol(SupportedProtocol.REQUEST_ENTITY)) {
                    ImGuiHelper.disabledMenuItem("Copy With Entities", "Server doesn't support (or doesn't allow) requesting entity data");
                    ImGuiHelper.disabledMenuItem("Copy With Air & Entities", "Server doesn't support (or doesn't allow) requesting entity data");
                } else {
                    if (ImGui.menuItem("Copy With Entities")) {
                        Selection.callCopy(false, true);
                    }
                    ImGuiHelper.tooltip("*** Only includes entities within render distance ***");
                    if (ImGui.menuItem("Copy With Air & Entities")) {
                        Selection.callCopy(true, true);
                    }
                    ImGuiHelper.tooltip("*** Only includes entities within render distance ***");
                }
                ImGui.endPopup();
            }
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.cut_selection", Keybinds.CUT.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                Selection.callAction(UserAction.CUT, null);
            }
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.duplicate_selection", Keybinds.DUPLICATE.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                Selection.callAction(UserAction.DUPLICATE, null);
            }
            ImGui.separator();
            MainMenuBar.renderOperationsImgui(false);
        }
        ImGui.end();
        if (!open.get()) {
            Selection.clearSelection();
        }
    }

    private static void renderModifySelection(int x, int y) {
        ImGui.setNextWindowPos(x - 10, y + 10, 1, 1.0f, 0.0f);
        ImBoolean open = new ImBoolean(true);
        String title = "Move Selection";
        if (ImGui.begin(title, open, 2101572)) {
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.confirm_selection", Keybinds.CONFIRM.longKeyIdentifier()))) {
                ModifySelection.finish();
            }
            ImGui.sameLine();
            ImGui.dummy(25.0f, 0.0f);
            ImGui.separator();
            if (ImGui.button("Rotate Y")) {
                ModifySelection.rotateY();
            }
            ImGui.sameLine();
            if (ImGui.button("Flip...")) {
                ImGui.openPopup("##FlipOptions");
            }
            if (ImGui.beginPopup("##FlipOptions")) {
                if (ImGui.menuItem("Flip X")) {
                    ModifySelection.flip(class_2350.class_2351.field_11048);
                    ImGui.closeCurrentPopup();
                }
                if (ImGui.menuItem("Flip Y")) {
                    ModifySelection.flip(class_2350.class_2351.field_11052);
                    ImGui.closeCurrentPopup();
                }
                if (ImGui.menuItem("Flip Z")) {
                    ModifySelection.flip(class_2350.class_2351.field_11051);
                    ImGui.closeCurrentPopup();
                }
                ImGui.endPopup();
            }
        }
        ImGui.end();
        if (!open.get()) {
            ModifySelection.cancelAndClearSelection();
        }
    }
}

