/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.text.NumberFormat;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class HollowOperation {
    public static void hollow() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            HollowOperation.hollowOrFillGapsAABB(aabb, false);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            HollowOperation.hollowOrFillGapsSet(set, false);
        }
    }

    public static void fillGaps() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            HollowOperation.hollowOrFillGapsAABB(aabb, true);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            HollowOperation.hollowOrFillGapsSet(set, true);
        }
    }

    private static void hollowOrFillGapsAABB(SelectionBuffer.AABB aabb, boolean fillGaps) {
        int z;
        int x;
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600() - 1, maxY);
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        PositionSet visited = new PositionSet();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x, maxY + 1, z), class_2350.field_11033, queue, visited);
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x, minY - 1, z), class_2350.field_11036, queue, visited);
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x, y, maxZ + 1), class_2350.field_11043, queue, visited);
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x, y, minZ - 1), class_2350.field_11035, queue, visited);
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (z = minZ; z <= maxZ; ++z) {
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(maxX + 1, y, z), class_2350.field_11039, queue, visited);
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(minX - 1, y, z), class_2350.field_11034, queue, visited);
            }
        }
        class_2350[] directions = class_2350.values();
        while (!queue.isEmpty()) {
            long pos = queue.dequeueLong();
            for (class_2350 direction : directions) {
                mutableBlockPos.method_16363(pos);
                int neighborX = mutableBlockPos.method_10263() + direction.method_10148();
                int neighborY = mutableBlockPos.method_10264() + direction.method_10164();
                int neighborZ = mutableBlockPos.method_10260() + direction.method_10165();
                if (neighborX < minX || neighborY < minY || neighborZ < minZ || neighborX > maxX || neighborY > maxY || neighborZ > maxZ || visited.contains(neighborX, neighborY, neighborZ)) continue;
                HollowOperation.propagate((class_1937)world, mutableBlockPos, direction, queue, visited);
            }
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        int changeCount = 0;
        class_2680 activeBlock = Tool.getActiveBlock();
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z2 = minZ; z2 <= maxZ; ++z2) {
                    class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x2, y, z2));
                    if (block.method_26204() == class_2246.field_10243 || block.method_26215() != fillGaps || visited.contains(x2, y, z2) || visited.contains(x2 + 1, y, z2) || visited.contains(x2 - 1, y, z2) || visited.contains(x2, y + 1, z2) || visited.contains(x2, y - 1, z2) || visited.contains(x2, y, z2 + 1) || visited.contains(x2, y, z2 - 1)) continue;
                    ++changeCount;
                    if (fillGaps) {
                        setOperation.set(x2, y, z2, activeBlock);
                        previousBlocksForUndo.set(x2, y, z2, block);
                        continue;
                    }
                    setOperation.set(x2, y, z2, class_2246.field_10124.method_9564());
                    previousBlocksForUndo.set(x2, y, z2, block);
                }
            }
        }
        String desc = fillGaps ? "axiom.history_description.filled_gaps" : "axiom.history_description.hollowed";
        String countString = NumberFormat.getInstance().format(changeCount);
        String historyDescription = AxiomI18n.get(desc, countString);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, aabb.center(), historyDescription, 0), Dispatcher.simpleSourceInfo("Hollow Operation"));
    }

    private static void hollowOrFillGapsSet(SelectionBuffer.Set set, boolean fillGaps) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        ChunkedBooleanRegion region = set.selectionRegion;
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        PositionSet visited = new PositionSet();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        region.forEach((x, y, z) -> {
            if (!region.contains(x + 1, y, z)) {
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x + 1, y, z), class_2350.field_11039, queue, visited);
            }
            if (!region.contains(x - 1, y, z)) {
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x - 1, y, z), class_2350.field_11034, queue, visited);
            }
            if (!region.contains(x, y + 1, z)) {
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x, y + 1, z), class_2350.field_11033, queue, visited);
            }
            if (!region.contains(x, y - 1, z)) {
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x, y - 1, z), class_2350.field_11036, queue, visited);
            }
            if (!region.contains(x, y, z + 1)) {
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x, y, z + 1), class_2350.field_11043, queue, visited);
            }
            if (!region.contains(x, y, z - 1)) {
                HollowOperation.propagate((class_1937)world, mutableBlockPos.method_10103(x, y, z - 1), class_2350.field_11035, queue, visited);
            }
        });
        class_2350[] directions = class_2350.values();
        while (!queue.isEmpty()) {
            long pos = queue.dequeueLong();
            for (class_2350 direction : directions) {
                mutableBlockPos.method_16363(pos);
                int neighborX = mutableBlockPos.method_10263() + direction.method_10148();
                int neighborY = mutableBlockPos.method_10264() + direction.method_10164();
                int neighborZ = mutableBlockPos.method_10260() + direction.method_10165();
                if (!region.contains(neighborX, neighborY, neighborZ) || visited.contains(neighborX, neighborY, neighborZ)) continue;
                HollowOperation.propagate((class_1937)world, mutableBlockPos, direction, queue, visited);
            }
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper changeCount = new IntWrapper();
        class_2680 activeBlock = Tool.getActiveBlock();
        region.forEach((x, y, z) -> {
            class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (block.method_26204() == class_2246.field_10243) {
                return;
            }
            if (block.method_26215() != fillGaps) {
                return;
            }
            if (visited.contains(x, y, z)) {
                return;
            }
            if (visited.contains(x + 1, y, z) || !region.contains(x + 1, y, z)) {
                return;
            }
            if (visited.contains(x - 1, y, z) || !region.contains(x - 1, y, z)) {
                return;
            }
            if (visited.contains(x, y + 1, z) || !region.contains(x, y + 1, z)) {
                return;
            }
            if (visited.contains(x, y - 1, z) || !region.contains(x, y - 1, z)) {
                return;
            }
            if (visited.contains(x, y, z + 1) || !region.contains(x, y, z + 1)) {
                return;
            }
            if (visited.contains(x, y, z - 1) || !region.contains(x, y, z - 1)) {
                return;
            }
            ++changeCount.value;
            if (fillGaps) {
                setOperation.set(x, y, z, activeBlock);
                previousBlocksForUndo.set(x, y, z, block);
            } else {
                setOperation.set(x, y, z, class_2246.field_10124.method_9564());
                previousBlocksForUndo.set(x, y, z, block);
            }
        });
        String desc = fillGaps ? "axiom.history_description.filled_gaps" : "axiom.history_description.hollowed";
        String countString = NumberFormat.getInstance().format(changeCount.value);
        String historyDescription = AxiomI18n.get(desc, countString);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, set.center(), historyDescription, 0), Dispatcher.simpleSourceInfo("Hollow Operation"));
    }

    private static void propagate(class_1937 level, class_2338.class_2339 pos, class_2350 direction, LongArrayFIFOQueue queue, PositionSet visited) {
        class_265 toShape;
        class_2680 fromBlock = level.method_8320((class_2338)pos);
        class_265 fromShape = fromBlock.method_26173((class_1922)class_2682.field_12294, class_2338.field_10980, direction);
        pos.method_10098(direction);
        class_2680 toBlock = level.method_8320((class_2338)pos);
        if (toBlock.method_26225() && class_259.method_20713((class_265)fromShape, (class_265)(toShape = toBlock.method_26173((class_1922)class_2682.field_12294, class_2338.field_10980, direction.method_10153())))) {
            return;
        }
        queue.enqueue(pos.method_10063());
        visited.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }
}

