/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.annotations;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.MissingTextureImage;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.annotations.AnnotationHistoryElement;
import com.moulberry.axiom.annotations.AnnotationUpdateAction;
import com.moulberry.axiom.annotations.data.AnnotationData;
import com.moulberry.axiom.annotations.data.ImageAnnotationData;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.annotations.Annotation;
import com.moulberry.axiom.render.annotations.Annotations;
import com.moulberry.axiom.utils.Authorization;
import com.moulberry.axiom.utils.ColourUtils;
import java.awt.image.BufferedImage;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ImageAnnotation
implements Annotation {
    private final ImageAnnotationData data;
    private final Gizmo gizmo;
    private final Quaternionf additionalRotation = new Quaternionf();
    private class_1043 dynamicTexture = null;
    private CompletableFuture<BufferedImage> future;
    private boolean error = false;

    public ImageAnnotation(ImageAnnotationData data) {
        this.data = data;
        this.gizmo = new Gizmo(new class_243(data.position()));
        this.gizmo.translationSnapping = 16;
        this.gizmo.enableRotation = true;
        this.gizmo.rotationSnapRadians = (float)Math.PI / 180;
    }

    @Override
    public AnnotationData getData() {
        return this.data;
    }

    @Override
    public class_4076 getMinSectionY() {
        return class_4076.method_18680((class_2374)new class_243(this.data.position()));
    }

    @Override
    public class_4076 getMaxSection() {
        return class_4076.method_18680((class_2374)new class_243(this.data.position()));
    }

    @Override
    @Nullable
    public Gizmo getGizmo() {
        return this.gizmo;
    }

    @Override
    public void render(UUID uuid, class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection, class_276 renderTarget) {
        if (this.error) {
            this.renderImage(uuid, camera, matrices, this.data.width(), this.data.width(), MissingTextureImage.getTextureId(), renderTarget);
            return;
        }
        if (this.dynamicTexture == null) {
            this.createTexture();
            this.renderImage(uuid, camera, matrices, this.data.width(), this.data.width(), MissingTextureImage.getTextureId(), renderTarget);
            return;
        }
        if (this.dynamicTexture.method_4525() == null) {
            return;
        }
        float height = this.data.width() * (float)this.dynamicTexture.method_4525().method_4323() / (float)this.dynamicTexture.method_4525().method_4307();
        this.renderImage(uuid, camera, matrices, this.data.width(), height, new AxiomGpuTexture(this.dynamicTexture.method_4624()), renderTarget);
    }

    private void createTexture() {
        if (this.future != null) {
            if (this.future.isDone()) {
                this.tryUploadtexture();
            }
        } else {
            this.future = ImageAnnotation.downloadTexture(this.data.imageUrl());
        }
    }

    private void tryUploadtexture() {
        BufferedImage image;
        try {
            image = this.future.join();
        }
        catch (Exception e) {
            Axiom.LOGGER.error("Failed to download annotation image", e);
            this.error = true;
            return;
        }
        if (image == null) {
            this.error = true;
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        class_1011 nativeImage = new class_1011(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = image.getRGB(x, y);
                nativeImage.method_4305(x, y, ColourUtils.argbToAbgr(argb));
            }
        }
        this.dynamicTexture = VersionUtilsClient.helperCreateFromNativeImageDynamicTexture(null, nativeImage);
    }

    private static CompletableFuture<BufferedImage> downloadTexture(String imageUrl) {
        CompletableFuture<BufferedImage> future = new CompletableFuture<BufferedImage>();
        class_156.method_18349().execute(() -> {
            HttpURLConnection connection = null;
            Axiom.LOGGER.info("Downloading image annotation from: {}", (Object)imageUrl);
            try {
                connection = (HttpURLConnection)new URL(imageUrl).openConnection();
                connection.setRequestProperty("User-Agent", Authorization.getUserAgent());
                connection.setDoInput(true);
                connection.setDoOutput(false);
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                if (connection.getResponseCode() / 100 != 2) {
                    future.completeExceptionally(new RuntimeException("Unable to download image: " + connection.getResponseCode()));
                    return;
                }
                future.complete(ImageIO.read(connection.getInputStream()));
                connection = null;
            }
            catch (Throwable t2) {
                future.completeExceptionally(t2);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
        return future;
    }

    private void renderImage(UUID uuid, class_4184 camera, class_4587 matrices, float width, float height, AxiomGpuTexture texture, class_276 renderTarget) {
        float directionXRot;
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        Matrix4f pose = matrices.method_23760().method_23761();
        float directionYRot = switch (this.data.direction()) {
            case class_2350.field_11036 -> {
                directionXRot = -90.0f;
                yield this.data.fallbackYaw() - 180.0f;
            }
            case class_2350.field_11033 -> {
                directionXRot = 90.0f;
                yield this.data.fallbackYaw() - 180.0f;
            }
            default -> {
                directionXRot = 0.0f;
                yield this.data.direction().method_10144();
            }
        };
        Quaternionf quaternionf = new Quaternionf();
        switch (this.data.billboardMode()) {
            case 0: {
                quaternionf.rotationYXZ((float)(-Math.PI) / 180 * directionYRot, (float)Math.PI / 180 * directionXRot, 0.0f);
                break;
            }
            case 1: {
                quaternionf.rotationYXZ((float)(-Math.PI) / 180 * directionYRot, (float)Math.PI / 180 * -camera.method_19329(), 0.0f);
                break;
            }
            case 2: {
                quaternionf.rotationYXZ((float)(-Math.PI) / 180 * (camera.method_19330() - 180.0f), (float)Math.PI / 180 * directionXRot, 0.0f);
                break;
            }
            default: {
                quaternionf.rotationYXZ((float)(-Math.PI) / 180 * (camera.method_19330() - 180.0f), (float)Math.PI / 180 * -camera.method_19329(), 0.0f);
            }
        }
        Gizmo.GizmoRotation gizmoRotation = this.gizmo.popRotation();
        if (gizmoRotation != null && gizmoRotation.radians() != 0.0f) {
            Quaternionf inverse = new Quaternionf((Quaternionfc)quaternionf).invert();
            quaternionf.premul((Quaternionfc)this.additionalRotation);
            quaternionf.premul((Quaternionfc)gizmoRotation.toQuaternion());
            Quaternionf previousRotation = new Quaternionf((Quaternionfc)this.additionalRotation);
            quaternionf.mul((Quaternionfc)inverse, this.additionalRotation);
            if (!Objects.equals(previousRotation, this.additionalRotation)) {
                Annotations.push(new AnnotationHistoryElement(new AnnotationUpdateAction.RotateAnnotation(uuid, previousRotation), new AnnotationUpdateAction.RotateAnnotation(uuid, new Quaternionf((Quaternionfc)this.additionalRotation))));
            }
        } else {
            quaternionf.premul((Quaternionfc)this.additionalRotation);
            Gizmo.GizmoRotation peeked = this.gizmo.peekGizmoRotation();
            if (peeked != null) {
                quaternionf.premul((Quaternionfc)peeked.toQuaternion());
            }
        }
        if (!this.gizmo.isGrabbed()) {
            this.gizmo.moveToVecInstantly(new class_243(this.data.position()));
            this.additionalRotation.set((Quaternionfc)this.data.rotation());
        }
        float halfWidth = width / 2.0f;
        float halfHeight = height / 2.0f;
        Vector3f a = quaternionf.transform(new Vector3f(-halfWidth, halfHeight, 0.0f));
        Vector3f b = quaternionf.transform(new Vector3f(halfWidth, halfHeight, 0.0f));
        Vector3f c = quaternionf.transform(new Vector3f(halfWidth, -halfHeight, 0.0f));
        Vector3f d = quaternionf.transform(new Vector3f(-halfWidth, -halfHeight, 0.0f));
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27382, class_290.field_1585);
        Vector3f position = this.gizmo.getInterpPosition().method_46409();
        VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose, position.x + a.x, position.y + a.y, position.z + a.z).method_22913(0.0f, 0.0f);
        VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose, position.x + b.x, position.y + b.y, position.z + b.z).method_22913(1.0f, 0.0f);
        VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose, position.x + c.x, position.y + c.y, position.z + c.z).method_22913(1.0f, 1.0f);
        VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose, position.x + d.x, position.y + d.y, position.z + d.z).method_22913(0.0f, 1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.data.opacity());
        RenderSystem.setShaderTexture((int)0, (int)texture.glId());
        AxiomRenderPipelines.IMAGE_ANNOTATION_PIPELINE.render(renderTarget, provider.build());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22909();
    }

    @Override
    public void sectionChanged() {
    }

    @Override
    public void close() {
        if (this.dynamicTexture != null) {
            this.dynamicTexture.close();
            this.dynamicTexture = null;
        }
        this.future = null;
    }
}

