/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.magic_select;

import com.moulberry.axiom.AsyncChunkProvider;
import com.moulberry.axiom.block_maps.FamilyMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.utils.IntWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5794;

public class MagicSelectionTask {
    public static int PROPAGATION_FLAG_UP = 1;
    public static int PROPAGATION_FLAG_DOWN = 2;
    public static int PROPAGATION_FLAG_HORIZONTAL = 4;
    public static int PROPAGATION_FLAG_CORNERS = 8;
    protected final PositionSet alreadyChecked = new PositionSet();
    protected final LongArrayFIFOQueue toCheck = new LongArrayFIFOQueue();
    protected final AsyncChunkProvider chunkProvider;
    public PositionSet positionSet;
    private final int compareMode;
    private class_2248 originalBlock;
    protected class_2680 originalBlockState;
    private class_5794 originalBlockFamily;
    protected MaskContext maskContext;
    protected MaskElement maskElement;
    protected int propagationFlags = 0;
    public final IntWrapper fillCount = new IntWrapper();
    protected int until = 0;

    public MagicSelectionTask(PositionSet positionSet, class_1937 world, class_2338 position, int compareMode, MaskElement maskElement, int propagationFlags) {
        this.originalBlockState = world.method_8320(position);
        this.originalBlock = this.originalBlockState.method_26204();
        this.originalBlockFamily = FamilyMap.getFamilyFor(this.originalBlockState.method_26204());
        this.positionSet = positionSet;
        this.chunkProvider = new AsyncChunkProvider(world);
        this.compareMode = compareMode;
        this.propagationFlags = propagationFlags;
        if (this.compareMode == 2 && !this.originalBlockState.method_51366()) {
            return;
        }
        this.maskContext = new MaskContext(this.chunkProvider);
        this.maskElement = maskElement;
        if (this.maskElement.test(this.maskContext.reset(), position.method_10263(), position.method_10264(), position.method_10260())) {
            this.positionSet.add(position.method_10263(), position.method_10264(), position.method_10260());
            ++this.fillCount.value;
            this.toCheck.enqueue(class_2338.method_10064((int)position.method_10263(), (int)position.method_10264(), (int)position.method_10260()));
            this.alreadyChecked.add(position.method_10263(), position.method_10264(), position.method_10260());
        }
    }

    protected boolean matches(class_2680 blockState) {
        return switch (this.compareMode) {
            default -> {
                if (blockState.method_26204() == this.originalBlock) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (blockState == this.originalBlockState) {
                    yield true;
                }
                yield false;
            }
            case 2 -> blockState.method_51366();
            case 3 -> {
                if (blockState.method_26204() == this.originalBlock) {
                    yield true;
                }
                if (this.originalBlockFamily != null) {
                    if (FamilyMap.getFamilyFor(blockState.method_26204()) == this.originalBlockFamily) {
                        yield true;
                    }
                    yield false;
                }
                yield false;
            }
            case 4 -> !blockState.method_26215();
        };
    }

    public void fill(int until) {
        int z;
        int y;
        int x;
        long pos;
        boolean checkCorner;
        boolean checkDown;
        if (until < 0) {
            throw new IllegalArgumentException();
        }
        this.until = until;
        IntWrapper count = this.fillCount;
        LongArrayFIFOQueue toCheck = this.toCheck;
        boolean checkUp = (this.propagationFlags & PROPAGATION_FLAG_UP) != 0;
        boolean bl = checkDown = (this.propagationFlags & PROPAGATION_FLAG_DOWN) != 0;
        if ((this.propagationFlags & PROPAGATION_FLAG_HORIZONTAL) == 0) {
            if (!checkUp && !checkDown) {
                return;
            }
            while (!toCheck.isEmpty() && count.value < until) {
                long pos2 = toCheck.dequeueLong();
                int x2 = class_2338.method_10061((long)pos2);
                int y2 = class_2338.method_10071((long)pos2);
                int z2 = class_2338.method_10083((long)pos2);
                if (checkDown) {
                    this.tryQueueCautious(x2, y2 - 1, z2);
                }
                if (!checkUp) continue;
                this.tryQueueCautious(x2, y2 + 1, z2);
            }
            return;
        }
        boolean bl2 = checkCorner = (this.propagationFlags & PROPAGATION_FLAG_CORNERS) != 0;
        while (!toCheck.isEmpty() && count.value < until - 27) {
            boolean hasPlusY;
            pos = toCheck.dequeueLong();
            x = class_2338.method_10061((long)pos);
            y = class_2338.method_10071((long)pos);
            z = class_2338.method_10083((long)pos);
            boolean hasMinusX = this.tryQueueContains(x - 1, y, z);
            boolean hasPlusX = this.tryQueueContains(x + 1, y, z);
            boolean hasMinusZ = this.tryQueueContains(x, y, z - 1);
            boolean hasPlusZ = this.tryQueueContains(x, y, z + 1);
            boolean hasMinusY = checkDown ? this.tryQueueContains(x, y - 1, z) : true;
            boolean bl3 = hasPlusY = checkUp ? this.tryQueueContains(x, y + 1, z) : true;
            if (!checkCorner || hasMinusX && hasPlusX && hasMinusZ && hasPlusZ && hasMinusY && hasPlusY) continue;
            if (!hasMinusX) {
                if (!hasMinusZ && !this.tryQueueContains(x - 1, y, z - 1)) {
                    if (!hasMinusY) {
                        this.tryQueue(x - 1, y - 1, z - 1);
                    }
                    if (!hasPlusY) {
                        this.tryQueue(x - 1, y + 1, z - 1);
                    }
                }
                if (!hasPlusZ && !this.tryQueueContains(x - 1, y, z + 1)) {
                    if (!hasMinusY) {
                        this.tryQueue(x - 1, y - 1, z + 1);
                    }
                    if (!hasPlusY) {
                        this.tryQueue(x - 1, y + 1, z + 1);
                    }
                }
                if (!hasMinusY) {
                    this.tryQueue(x - 1, y - 1, z);
                }
                if (!hasPlusY) {
                    this.tryQueue(x - 1, y + 1, z);
                }
            }
            if (!hasPlusX) {
                if (!hasMinusZ && !this.tryQueueContains(x + 1, y, z - 1)) {
                    if (!hasMinusY) {
                        this.tryQueue(x + 1, y - 1, z - 1);
                    }
                    if (!hasPlusY) {
                        this.tryQueue(x + 1, y + 1, z - 1);
                    }
                }
                if (!hasPlusZ && !this.tryQueueContains(x + 1, y, z + 1)) {
                    if (!hasMinusY) {
                        this.tryQueue(x + 1, y - 1, z + 1);
                    }
                    if (!hasPlusY) {
                        this.tryQueue(x + 1, y + 1, z + 1);
                    }
                }
                if (!hasMinusY) {
                    this.tryQueue(x + 1, y - 1, z);
                }
                if (!hasPlusY) {
                    this.tryQueue(x + 1, y + 1, z);
                }
            }
            if (!hasMinusZ) {
                if (!hasMinusY) {
                    this.tryQueue(x, y - 1, z - 1);
                }
                if (!hasPlusY) {
                    this.tryQueue(x, y + 1, z - 1);
                }
            }
            if (hasPlusZ) continue;
            if (!hasMinusY) {
                this.tryQueue(x, y - 1, z + 1);
            }
            if (hasPlusY) continue;
            this.tryQueue(x, y + 1, z + 1);
        }
        while (!toCheck.isEmpty() && count.value < until) {
            pos = toCheck.dequeueLong();
            x = class_2338.method_10061((long)pos);
            y = class_2338.method_10071((long)pos);
            z = class_2338.method_10083((long)pos);
            this.tryQueueCautious(x - 1, y, z);
            this.tryQueueCautious(x + 1, y, z);
            this.tryQueueCautious(x, y, z - 1);
            this.tryQueueCautious(x, y, z + 1);
            if (checkDown) {
                this.tryQueueCautious(x, y - 1, z);
            }
            if (checkUp) {
                this.tryQueueCautious(x, y + 1, z);
            }
            if (!checkCorner) continue;
            this.tryQueueCautious(x - 1, y, z - 1);
            this.tryQueueCautious(x - 1, y, z + 1);
            this.tryQueueCautious(x + 1, y, z - 1);
            this.tryQueueCautious(x + 1, y, z + 1);
            if (checkDown) {
                this.tryQueueCautious(x - 1, y - 1, z);
                this.tryQueueCautious(x + 1, y - 1, z);
            }
            if (checkUp) {
                this.tryQueueCautious(x - 1, y + 1, z);
                this.tryQueueCautious(x + 1, y + 1, z);
            }
            if (checkDown) {
                this.tryQueueCautious(x, y - 1, z - 1);
                this.tryQueueCautious(x, y - 1, z + 1);
            }
            if (checkUp) {
                this.tryQueueCautious(x, y + 1, z - 1);
                this.tryQueueCautious(x, y + 1, z + 1);
            }
            if (checkDown) {
                this.tryQueueCautious(x - 1, y - 1, z - 1);
                this.tryQueueCautious(x + 1, y - 1, z - 1);
                this.tryQueueCautious(x - 1, y - 1, z + 1);
                this.tryQueueCautious(x + 1, y - 1, z + 1);
            }
            if (!checkUp) continue;
            this.tryQueueCautious(x - 1, y + 1, z - 1);
            this.tryQueueCautious(x + 1, y + 1, z - 1);
            this.tryQueueCautious(x - 1, y + 1, z + 1);
            this.tryQueueCautious(x + 1, y + 1, z + 1);
        }
    }

    private void tryQueue(int x1, int y1, int z1) {
        class_2680 blockState;
        if (this.alreadyChecked.add(x1, y1, z1) && this.matches(blockState = this.chunkProvider.get(x1, y1, z1)) && this.maskElement.test(this.maskContext.reset(), x1, y1, z1)) {
            this.toCheck.enqueue(class_2338.method_10064((int)x1, (int)y1, (int)z1));
            this.positionSet.add(x1, y1, z1);
            ++this.fillCount.value;
        }
    }

    private void tryQueueCautious(int x1, int y1, int z1) {
        class_2680 blockState;
        if (this.fillCount.value >= this.until) {
            return;
        }
        if (this.alreadyChecked.add(x1, y1, z1) && this.matches(blockState = this.chunkProvider.get(x1, y1, z1)) && this.maskElement.test(this.maskContext.reset(), x1, y1, z1)) {
            this.toCheck.enqueue(class_2338.method_10064((int)x1, (int)y1, (int)z1));
            this.positionSet.add(x1, y1, z1);
            ++this.fillCount.value;
        }
    }

    private boolean tryQueueContains(int x1, int y1, int z1) {
        if (this.alreadyChecked.add(x1, y1, z1)) {
            class_2680 blockState = this.chunkProvider.get(x1, y1, z1);
            if (this.matches(blockState) && this.maskElement.test(this.maskContext.reset(), x1, y1, z1)) {
                this.toCheck.enqueue(class_2338.method_10064((int)x1, (int)y1, (int)z1));
                this.positionSet.add(x1, y1, z1);
                ++this.fillCount.value;
                return true;
            }
            return false;
        }
        return this.positionSet.contains(x1, y1, z1);
    }
}

