/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.modelling;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.gizmo.ExtrudedGizmo;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.rasterization.HullRasterization;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.rasterization.SmartSurfaceRasterization;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.modelling.GizmoList;
import com.moulberry.axiom.tools.modelling.GridSurface;
import com.moulberry.axiom.utils.ExpandOffsets;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.undo.ModellingAdditionalUndoOperation;
import com.moulberry.axiomclientapi.pathers.BallShape;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class ModellingTool
implements Tool {
    private ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private GizmoList gizmoList = new GizmoList();
    private final List<GizmoList> gridGizmos = new ArrayList<GizmoList>();
    private boolean recalculate = false;
    private class_2680 lastActiveBlock = null;
    private boolean maskWindowOpen = false;
    private Future<ChunkedBlockRegion> pendingCalculation = null;
    private ExtrudedGizmo extrudedGizmo = null;
    private static final int MODE_FLAT_SURFACE = 0;
    private static final int MODE_CATMULL_ROM_SURFACE = 1;
    private static final int MODE_BEZIER_SURFACE = 2;
    private static final int MODE_CONVEX_HULL = 3;
    private static final int MODE_SMART_SURFACE = 4;
    private static final int MODE_TRIANGLE_STRIP = 5;
    private static final int MODE_TRIANGLE_FAN = 6;
    private final int[] mode = new int[]{0};
    private final int[] thickness = new int[]{1};
    private boolean visualizeMesh = false;
    private boolean offsetWhenPlacing = true;
    private boolean keepExisting = false;
    private boolean extendToGround = false;

    public ModellingTool() {
        this.gridGizmos.add(this.gizmoList);
    }

    @Override
    public void reset() {
        this.gizmoList = new GizmoList();
        this.gridGizmos.clear();
        this.gridGizmos.add(this.gizmoList);
        this.chunkedBlockRegion.clear();
        this.recalculate = true;
    }

    public void restore(List<List<class_2338>> positions, int mode, int thickness, boolean keepExisting, boolean extendToGround) {
        this.reset();
        if (positions.isEmpty()) {
            return;
        }
        this.gridGizmos.clear();
        for (List<class_2338> line : positions) {
            this.gizmoList.deselectActiveGizmo();
            this.gizmoList = new GizmoList();
            for (class_2338 pos : line) {
                this.gizmoList.addGizmo(class_243.method_24953((class_2382)pos));
            }
            this.gridGizmos.add(this.gizmoList);
        }
        this.mode[0] = mode;
        this.thickness[0] = thickness;
        this.keepExisting = keepExisting;
        this.extendToGround = extendToGround;
    }

    public void markDirty() {
        this.recalculate = true;
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case EXTRUDE: {
                if (this.extrudedGizmo == null) {
                    this.extrudedGizmo = this.gizmoList.extrude();
                    if (this.extrudedGizmo == null) {
                        for (GizmoList line : this.gridGizmos) {
                            this.extrudedGizmo = line.extrude();
                            if (this.extrudedGizmo == null) continue;
                            break;
                        }
                    }
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case ENTER: {
                if (this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                this.pasteShape();
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case RIGHT_MOUSE: {
                if (this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
                if (result != null) {
                    class_2338 blockPos = result.blockPos();
                    if (this.offsetWhenPlacing) {
                        blockPos = blockPos.method_10093(result.direction());
                    }
                    for (GizmoList line : this.gridGizmos) {
                        if (line == this.gizmoList) continue;
                        line.deselectActiveGizmo();
                    }
                    this.gizmoList.addGizmo(class_243.method_24953((class_2382)blockPos));
                    this.recalculate = true;
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (this.extrudedGizmo != null) {
                    this.finishExtrudeGizmo();
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmoList.leftClick()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                for (GizmoList line : this.gridGizmos) {
                    if (!line.leftClick()) continue;
                    this.gizmoList = line;
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case ESCAPE: {
                if (this.extrudedGizmo != null) {
                    this.extrudedGizmo = null;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (!this.gizmoList.hasActiveGizmo()) break;
                this.gizmoList.deselectActiveGizmo();
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: {
                if (this.extrudedGizmo != null) {
                    this.extrudedGizmo = null;
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.gizmoList.isEmpty()) {
                    this.reset();
                } else {
                    this.gizmoList.delete();
                }
                this.recalculate = true;
                return UserAction.ActionResult.USED_STOP;
            }
            case SCROLL: {
                UserAction.ScrollAmount scrollAmount = (UserAction.ScrollAmount)object;
                if (!this.handleScroll(scrollAmount.scrollX(), scrollAmount.scrollY())) break;
                this.recalculate = true;
                return UserAction.ActionResult.USED_STOP;
            }
            case REDO: {
                if (!this.gizmoList.redo()) break;
                this.recalculate = true;
                return UserAction.ActionResult.USED_STOP;
            }
            case UNDO: {
                if (!this.gizmoList.undo()) break;
                this.recalculate = true;
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private void finishExtrudeGizmo() {
        for (GizmoList line : this.gridGizmos) {
            if (line == this.gizmoList) continue;
            line.deselectActiveGizmo();
        }
        this.gizmoList.finishExtrude(this.extrudedGizmo, Tool.getLookDirection());
        this.recalculate = true;
        this.extrudedGizmo = null;
    }

    public boolean handleScroll(int xScroll, int yScroll) {
        return this.gizmoList.handleScroll(xScroll, yScroll);
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        boolean maskWindowOpen;
        RayCaster.RaycastResult result;
        class_243 lookDirection = Tool.getLookDirection();
        if (lookDirection != null && this.extrudedGizmo != null) {
            this.extrudedGizmo.render(matrices, camera, lookDirection);
        }
        if (this.modeSupportsGridGizmos()) {
            for (GizmoList line : this.gridGizmos) {
                this.recalculate |= line.updateGizmos(camera, time);
            }
        } else {
            this.recalculate |= this.gizmoList.updateGizmos(camera, time);
        }
        if (!this.gizmoList.hasGrabbedGizmo() && this.extrudedGizmo == null && (result = Tool.raycastBlock(false, true, true)) != null) {
            class_2338 blockPos = result.blockPos();
            if (this.offsetWhenPlacing) {
                blockPos = blockPos.method_10093(result.direction());
            }
            Tool.renderRaycastOverlay(blockPos, matrices, camera);
        }
        if (Tool.getActiveBlock() != this.lastActiveBlock) {
            this.lastActiveBlock = Tool.getActiveBlock();
            this.recalculate = true;
        }
        if (this.maskWindowOpen != (maskWindowOpen = EditorWindowType.TOOL_MASKS.isOpen())) {
            this.maskWindowOpen = maskWindowOpen;
            this.recalculate = true;
        }
        if (this.recalculate) {
            this.recalculate();
        }
        if (this.pendingCalculation != null && this.pendingCalculation.isDone()) {
            this.chunkedBlockRegion.clear();
            try {
                ChunkedBlockRegion output = this.pendingCalculation.get();
                if (output != null) {
                    this.chunkedBlockRegion = output;
                }
            }
            catch (Exception output) {
                // empty catch block
            }
            this.pendingCalculation = null;
        }
        if (!this.chunkedBlockRegion.isEmpty()) {
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.renderShapeBounds(matrices, camera);
        }
        if (this.modeSupportsGridGizmos()) {
            for (GizmoList gridGizmo : this.gridGizmos) {
                gridGizmo.renderGizmos(matrices, camera);
            }
        } else {
            this.gizmoList.renderGizmos(matrices, camera);
        }
    }

    private boolean modeSupportsGridGizmos() {
        return this.mode[0] == 2 || this.mode[0] == 1 || this.mode[0] == 0;
    }

    private void renderShapeBounds(class_4587 matrices, class_4184 camera) {
        RayCaster.RaycastResult result;
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
        class_4587.class_4665 pose = matrices.method_23760();
        class_243 previewNewPos = null;
        if (this.gizmoList.hasActiveGizmo() && !Tool.isMouseDown(1) && !Tool.isMouseDown(0) && !EditorUI.isCtrlOrCmdDown() && (result = Tool.raycastBlock(false, true, true)) != null) {
            class_2338 blockPos = result.blockPos();
            if (this.offsetWhenPlacing) {
                blockPos = blockPos.method_10093(result.direction());
            }
            previewNewPos = class_243.method_24953((class_2382)blockPos);
        }
        switch (this.mode[0]) {
            case 0: 
            case 1: 
            case 2: {
                List<Gizmo> lastLine = null;
                for (GizmoList gizmoList : this.gridGizmos) {
                    if (gizmoList.isEmpty()) continue;
                    List<Gizmo> line = gizmoList.getGizmos();
                    for (int i = 0; i < line.size() - 1; ++i) {
                        boolean isActive = gizmoList == this.gizmoList;
                        class_243 from = line.get(i).getInterpPosition();
                        class_243 to = line.get(i + 1).getInterpPosition();
                        Shapes.line(bufferBuilder, pose, isActive ? 0.0f : 1.0f, isActive ? 1.0f : 0.0f, 0.0f, from, to);
                        if (!isActive || previewNewPos == null || !line.get((int)i).enableAxes) continue;
                        Shapes.line(bufferBuilder, pose, 1.0f, 1.0f, 1.0f, from, previewNewPos);
                        Shapes.line(bufferBuilder, pose, 1.0f, 1.0f, 1.0f, previewNewPos, to);
                    }
                    if (lastLine != null) {
                        ModellingTool.drawConnectingLines(line, lastLine, bufferBuilder, pose);
                    }
                    lastLine = line;
                }
                break;
            }
            case 5: {
                List<Gizmo> gizmos = this.gizmoList.getGizmos();
                for (int i = 0; i < gizmos.size() - 1; ++i) {
                    class_243 from = gizmos.get(i).getInterpPosition();
                    class_243 to = gizmos.get(i + 1).getInterpPosition();
                    Shapes.line(bufferBuilder, pose, 1.0f, 0.0f, 0.0f, from, to);
                    if (i >= gizmos.size() - 2) continue;
                    to = gizmos.get(i + 2).getInterpPosition();
                    Shapes.line(bufferBuilder, pose, 1.0f, 0.0f, 0.0f, from, to);
                }
                break;
            }
            case 6: {
                List<Gizmo> gizmos = this.gizmoList.getGizmos();
                if (gizmos.isEmpty()) break;
                class_243 start = gizmos.get(0).getInterpPosition();
                for (int i = 1; i < gizmos.size(); ++i) {
                    class_243 curr = gizmos.get(i).getInterpPosition();
                    Shapes.line(bufferBuilder, pose, 1.0f, 0.0f, 0.0f, start, curr);
                    if (i >= gizmos.size() - 1) continue;
                    class_243 next2 = gizmos.get(i + 1).getInterpPosition();
                    Shapes.line(bufferBuilder, pose, 1.0f, 0.0f, 0.0f, curr, next2);
                }
                break;
            }
        }
        class_287.class_7433 meshData = VersionUtilsClient.helperOldBufferBuilderEndOrDiscard(bufferBuilder);
        if (meshData != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(meshData);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrices.method_22909();
    }

    private static void drawConnectingLines(List<Gizmo> one, List<Gizmo> two, class_287 bufferBuilder, class_4587.class_4665 pose) {
        if (one.isEmpty() || two.isEmpty()) {
            return;
        }
        if (one.size() < two.size()) {
            List<Gizmo> temp = one;
            one = two;
            two = temp;
        }
        int skip = 0;
        while (one.size() - skip * 2 >= two.size() + 2) {
            class_243 from = one.get(skip).getInterpPosition();
            class_243 to = two.get(0).getInterpPosition();
            Shapes.line(bufferBuilder, pose, 0.33f, 1.0f, 1.0f, from, to);
            from = one.get(one.size() - 1 - skip).getInterpPosition();
            to = two.get(two.size() - 1).getInterpPosition();
            Shapes.line(bufferBuilder, pose, 0.33f, 1.0f, 1.0f, from, to);
            ++skip;
        }
        if (one.size() - skip * 2 == two.size()) {
            for (int i = 0; i < two.size(); ++i) {
                from = two.get(i).getInterpPosition();
                class_243 to = one.get(skip + i).getInterpPosition();
                Shapes.line(bufferBuilder, pose, 0.33f, 1.0f, 1.0f, from, to);
            }
        } else {
            for (int i = 0; i < two.size(); ++i) {
                from = two.get(i).getInterpPosition();
                class_243 to = one.get(skip + i).getInterpPosition();
                Shapes.line(bufferBuilder, pose, 0.33f, 1.0f, 1.0f, from, to);
                to = one.get(skip + i + 1).getInterpPosition();
                Shapes.line(bufferBuilder, pose, 0.33f, 1.0f, 1.0f, from, to);
            }
        }
    }

    private void pasteShape() {
        List<List<class_2338>> positions = this.convertGizmosToPositions();
        ChunkedBlockRegion result = ModellingTool.calculate(this.mode[0], positions, Tool.getActiveBlock(), this.visualizeMesh, this.thickness[0]);
        if (result == null || result.isEmpty()) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (this.extendToGround && level != null) {
            Position2ObjectMap<class_2680> newBlocks = new Position2ObjectMap<class_2680>(k -> new class_2680[4096]);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            result.forEachEntry((arg_0, arg_1, arg_2, arg_3) -> ModellingTool.lambda$pasteShape$1(result, (class_1937)level, mutableBlockPos, newBlocks, arg_0, arg_1, arg_2, arg_3));
            newBlocks.forEachEntry(result::addBlock);
        }
        class_2487 sourceInfo = Dispatcher.simpleSourceInfo("Shape Tool");
        String countString = NumberFormat.getInstance().format(result.count());
        String historyDescription = AxiomI18n.get("axiom.history_description.placed", countString);
        int modifiers = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
        ModellingAdditionalUndoOperation additionalUndoOperation = new ModellingAdditionalUndoOperation(positions, this.mode[0], this.thickness[0], this.keepExisting, this.extendToGround);
        MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
        MaskElement maskElement = MaskManager.getDestMask();
        if (maskElement instanceof ConstantMaskElement) {
            ConstantMaskElement constantMaskElement = (ConstantMaskElement)maskElement;
            if (constantMaskElement.getConstant()) {
                RegionHelper.pushBlockRegionChange(result, null, historyDescription, sourceInfo, modifiers, additionalUndoOperation);
            }
        } else {
            ChunkedBlockRegion newChunkedBlockRegion = new ChunkedBlockRegion();
            result.forEachEntry((x, y, z, block) -> {
                if (maskElement.test(maskContext.reset(), x, y, z)) {
                    newChunkedBlockRegion.addBlockWithoutDirty(x, y, z, (class_2680)block);
                }
            });
            RegionHelper.pushBlockRegionChange(newChunkedBlockRegion, null, historyDescription, sourceInfo, modifiers, additionalUndoOperation);
        }
    }

    private void recalculate() {
        if (this.pendingCalculation != null) {
            return;
        }
        this.recalculate = false;
        if (this.gridGizmos.isEmpty() || this.gridGizmos.size() == 1 && this.gizmoList.isEmpty()) {
            this.chunkedBlockRegion.clear();
            return;
        }
        List<List<class_2338>> positions = this.convertGizmosToPositions();
        this.pendingCalculation = Tool.sharedSingleThreadExecutor.submit(() -> ModellingTool.calculate(this.mode[0], positions, Tool.getActiveBlock(), this.visualizeMesh, this.thickness[0]));
    }

    private List<List<class_2338>> convertGizmosToPositions() {
        ArrayList<List<class_2338>> positions = new ArrayList<List<class_2338>>();
        if (this.modeSupportsGridGizmos()) {
            for (GizmoList line : this.gridGizmos) {
                if (line.isEmpty()) continue;
                ArrayList<class_2338> linePositions = new ArrayList<class_2338>();
                for (Gizmo gizmo : line.getGizmos()) {
                    linePositions.add(gizmo.getTargetPosition());
                }
                positions.add(linePositions);
            }
        } else {
            ArrayList<class_2338> linePositions = new ArrayList<class_2338>();
            for (Gizmo gizmo : this.gizmoList.getGizmos()) {
                linePositions.add(gizmo.getTargetPosition());
            }
            positions.add(linePositions);
        }
        return positions;
    }

    private static ChunkedBlockRegion calculate(int mode, List<List<class_2338>> positions, class_2680 block, boolean visualizeMesh, int thickness) {
        if (positions.isEmpty()) {
            return null;
        }
        List<class_2338> singlePositions = positions.get(0);
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        switch (mode) {
            case 2: {
                if (thickness <= 1) {
                    GridSurface.calculateBezier(positions, (x, y, z) -> chunkedBlockRegion.addBlockWithoutDirty(x, y, z, block));
                    break;
                }
                PositionSet positionSet = new PositionSet();
                GridSurface.calculateBezier(positions, positionSet::add);
                int[][] allOffsets = ExpandOffsets.create(BallShape.SPHERE, thickness - 1);
                positionSet.forEach((x, y, z) -> {
                    int offsetIndex = 63;
                    if (positionSet.contains(x - 1, y, z)) {
                        --offsetIndex;
                    }
                    if (positionSet.contains(x, y - 1, z)) {
                        offsetIndex -= 2;
                    }
                    if (positionSet.contains(x, y, z - 1)) {
                        offsetIndex -= 4;
                    }
                    if (positionSet.contains(x + 1, y, z)) {
                        offsetIndex -= 8;
                    }
                    if (positionSet.contains(x, y + 1, z)) {
                        offsetIndex -= 16;
                    }
                    if (positionSet.contains(x, y, z + 1)) {
                        offsetIndex -= 32;
                    }
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, block);
                    int[] offsets = allOffsets[offsetIndex];
                    for (int i = 0; i < offsets.length; i += 3) {
                        chunkedBlockRegion.addBlockWithoutDirty(x + offsets[i], y + offsets[i + 1], z + offsets[i + 2], block);
                    }
                });
                break;
            }
            case 1: {
                if (thickness <= 1) {
                    GridSurface.calculateCatmullRom(positions, (x, y, z) -> chunkedBlockRegion.addBlockWithoutDirty(x, y, z, block));
                    break;
                }
                PositionSet positionSet = new PositionSet();
                GridSurface.calculateCatmullRom(positions, positionSet::add);
                int[][] allOffsets = ExpandOffsets.create(BallShape.SPHERE, thickness - 1);
                positionSet.forEach((x, y, z) -> {
                    int offsetIndex = 63;
                    if (positionSet.contains(x - 1, y, z)) {
                        --offsetIndex;
                    }
                    if (positionSet.contains(x, y - 1, z)) {
                        offsetIndex -= 2;
                    }
                    if (positionSet.contains(x, y, z - 1)) {
                        offsetIndex -= 4;
                    }
                    if (positionSet.contains(x + 1, y, z)) {
                        offsetIndex -= 8;
                    }
                    if (positionSet.contains(x, y + 1, z)) {
                        offsetIndex -= 16;
                    }
                    if (positionSet.contains(x, y, z + 1)) {
                        offsetIndex -= 32;
                    }
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, block);
                    int[] offsets = allOffsets[offsetIndex];
                    for (int i = 0; i < offsets.length; i += 3) {
                        chunkedBlockRegion.addBlockWithoutDirty(x + offsets[i], y + offsets[i + 1], z + offsets[i + 2], block);
                    }
                });
                break;
            }
            case 0: {
                if (thickness <= 1) {
                    GridSurface.calculateFlat(positions, (x, y, z) -> chunkedBlockRegion.addBlockWithoutDirty(x, y, z, block));
                    break;
                }
                PositionSet positionSet = new PositionSet();
                GridSurface.calculateFlat(positions, positionSet::add);
                int[][] allOffsets = ExpandOffsets.create(BallShape.SPHERE, thickness - 1);
                positionSet.forEach((x, y, z) -> {
                    int offsetIndex = 63;
                    if (positionSet.contains(x - 1, y, z)) {
                        --offsetIndex;
                    }
                    if (positionSet.contains(x, y - 1, z)) {
                        offsetIndex -= 2;
                    }
                    if (positionSet.contains(x, y, z - 1)) {
                        offsetIndex -= 4;
                    }
                    if (positionSet.contains(x + 1, y, z)) {
                        offsetIndex -= 8;
                    }
                    if (positionSet.contains(x, y + 1, z)) {
                        offsetIndex -= 16;
                    }
                    if (positionSet.contains(x, y, z + 1)) {
                        offsetIndex -= 32;
                    }
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, block);
                    int[] offsets = allOffsets[offsetIndex];
                    for (int i = 0; i < offsets.length; i += 3) {
                        chunkedBlockRegion.addBlockWithoutDirty(x + offsets[i], y + offsets[i + 1], z + offsets[i + 2], block);
                    }
                });
                break;
            }
            case 3: {
                if (singlePositions.isEmpty()) {
                    return null;
                }
                try {
                    double[] points = new double[singlePositions.size() * 3];
                    for (int i = 0; i < singlePositions.size(); ++i) {
                        class_2338 pos = singlePositions.get(i);
                        points[i * 3] = pos.method_10263();
                        points[i * 3 + 1] = pos.method_10264();
                        points[i * 3 + 2] = pos.method_10260();
                    }
                    HullRasterization.quickHullBlockRegion(chunkedBlockRegion, block, points);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                if (singlePositions.isEmpty()) {
                    return null;
                }
                class_2338[] points = new class_2338[singlePositions.size()];
                for (int i = 0; i < singlePositions.size(); ++i) {
                    points[i] = singlePositions.get(i);
                }
                SmartSurfaceRasterization.smartSurface(chunkedBlockRegion, block, points, visualizeMesh);
                break;
            }
            case 5: {
                if (singlePositions.isEmpty()) {
                    return null;
                }
                for (int i = 0; i < singlePositions.size() - 2; ++i) {
                    Rasterization3D.triangle(singlePositions.get(i), singlePositions.get(i + 1), singlePositions.get(i + 2), (x, y, z) -> chunkedBlockRegion.addBlockWithoutDirty(x, y, z, block));
                }
                break;
            }
            case 6: {
                if (singlePositions.isEmpty()) {
                    return null;
                }
                class_2338 start = singlePositions.get(0);
                for (int i = 1; i < singlePositions.size() - 1; ++i) {
                    Rasterization3D.triangle(start, singlePositions.get(i), singlePositions.get(i + 1), (x, y, z) -> chunkedBlockRegion.addBlockWithoutDirty(x, y, z, block));
                }
                break;
            }
        }
        chunkedBlockRegion.dirtyAll();
        chunkedBlockRegion.uniqueBlockState = block;
        return chunkedBlockRegion;
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.modelling"));
        boolean changed = ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape"), this.mode, new String[]{AxiomI18n.get("axiom.tool.shape.flat_surface"), AxiomI18n.get("axiom.tool.shape.catmull_rom_surface"), AxiomI18n.get("axiom.tool.shape.bezier_surface"), AxiomI18n.get("axiom.tool.shape.convex_hull"), AxiomI18n.get("axiom.tool.shape.smart_surface"), AxiomI18n.get("axiom.tool.shape.triangle_strip"), AxiomI18n.get("axiom.tool.shape.triangle_fan")});
        switch (this.mode[0]) {
            case 4: {
                ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.smart_surface"));
                if (!ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.smart_surface.visualize_mesh"), this.visualizeMesh)) break;
                this.visualizeMesh = !this.visualizeMesh;
                changed = true;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                changed |= ImGui.sliderInt("Thickness", this.thickness, 1, 16);
                ImGuiHelper.separatorWithText("Rows");
                int removeRow = -1;
                boolean canRemove = this.gridGizmos.size() > 1;
                for (int i = 0; i < this.gridGizmos.size(); ++i) {
                    boolean selected = this.gridGizmos.get(i) == this.gizmoList;
                    ImGui.pushID(i);
                    if (selected) {
                        ImGui.beginDisabled();
                    }
                    if (ImGui.smallButton("Row #" + (i + 1))) {
                        this.gizmoList = this.gridGizmos.get(i);
                    }
                    if (selected) {
                        ImGui.endDisabled();
                    }
                    if (canRemove) {
                        ImGui.sameLine();
                        if (ImGui.smallButton("X")) {
                            removeRow = i;
                        }
                    }
                    ImGui.popID();
                }
                if (canRemove && removeRow >= 0) {
                    GizmoList removed = this.gridGizmos.remove(removeRow);
                    if (removed == this.gizmoList) {
                        this.gizmoList = this.gridGizmos.get(this.gridGizmos.size() - 1);
                    }
                    this.recalculate = true;
                }
                if (!ImGui.smallButton("Add Row")) break;
                this.gizmoList = new GizmoList();
                this.gridGizmos.add(this.gizmoList);
            }
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.placement_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.offset_when_placing"), this.offsetWhenPlacing)) {
            this.offsetWhenPlacing = !this.offsetWhenPlacing;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.paste_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.keep_existing"), this.keepExisting)) {
            this.keepExisting = !this.keepExisting;
            changed = true;
        }
        ImGui.sameLine();
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.path.extend_to_ground"), this.extendToGround)) {
            this.extendToGround = !this.extendToGround;
            changed = true;
        }
        if (this.gizmoList.hasActiveGizmo()) {
            ImGui.separator();
            ImGui.text(AxiomI18n.get("axiom.tool.shape.extrude_tip", Keybinds.EXTRUDE_POINT.longKeyIdentifier()));
        }
        if (ImGui.button("Paste Copy")) {
            this.pasteShape();
        }
        if (changed) {
            this.recalculate = true;
        }
    }

    @Override
    public String listenForEsc() {
        if (this.gizmoList.hasActiveGizmo()) {
            return "Deselect Point";
        }
        if (!this.gizmoList.isEmpty()) {
            return AxiomI18n.get("axiom.widget.cancel");
        }
        return null;
    }

    @Override
    public String listenForEnter() {
        if (!this.chunkedBlockRegion.isEmpty()) {
            return AxiomI18n.get("axiom.widget.confirm");
        }
        return null;
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.modelling");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeSettings(class_2487 tag) {
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.recalculate = true;
    }

    @Override
    public char iconChar() {
        return '\ue928';
    }

    @Override
    public String keybindId() {
        return "modelling";
    }

    private static /* synthetic */ void lambda$pasteShape$1(ChunkedBlockRegion result, class_1937 level, class_2338.class_2339 mutableBlockPos, Position2ObjectMap newBlocks, int x, int y, int z, class_2680 block) {
        class_2680 below;
        for (int yo = 1; yo < 256 && result.getBlockStateOrAir(x, y - yo, z).method_26215() && (below = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - yo, z))).method_26204() != class_2246.field_10243 && below.method_45474(); ++yo) {
            newBlocks.put(x, y - yo, z, block);
        }
    }
}

