/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.world_modification.BiomeBuffer;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.undo.AdditionalUndoOperation;
import net.minecraft.class_155;
import net.minecraft.class_2338;
import net.minecraft.class_2540;

public record HistoryEntry<T>(T forwards, T backwards, class_2338 origin, String description, int bytes, int modifiers, AdditionalUndoOperation additionalUndoOperation) {
    public static int MODIFIER_PASTE = 1;
    public static int MODIFIER_CUT = 2;
    public static int MODIFIER_SELECT_ON_BACKSTEP = 4;
    public static int MODIFIER_CAN_BE_UNDONE_INGAME = 8;
    public static int MODIFIER_KEEP_EXISTING = 65536;

    public HistoryEntry(T forwards, T backwards, class_2338 origin, String description, int modifiers) {
        this(forwards, backwards, origin, description, HistoryEntry.calculateBytes(forwards, backwards), modifiers, null);
    }

    public HistoryEntry(T forwards, T backwards, class_2338 origin, String description, int modifiers, AdditionalUndoOperation additionalUndoOperation) {
        this(forwards, backwards, origin, description, HistoryEntry.calculateBytes(forwards, backwards), modifiers, additionalUndoOperation);
    }

    public void save(class_2540 out) {
        out.method_10807(this.origin);
        out.method_10814(this.description);
        out.writeByte(this.modifiers);
        out.writeInt(class_155.method_16673().method_37912().method_38494());
        T t2 = this.forwards;
        if (t2 instanceof BlockBuffer) {
            BlockBuffer blockBuffer = (BlockBuffer)t2;
            out.writeByte(0);
            blockBuffer.saveNBT(out);
            ((BlockBuffer)this.backwards).saveNBT(out);
        } else {
            t2 = this.forwards;
            if (t2 instanceof BiomeBuffer) {
                BiomeBuffer biomeBuffer = (BiomeBuffer)t2;
                out.writeByte(1);
                biomeBuffer.save(out);
                ((BiomeBuffer)this.backwards).save(out);
            } else {
                throw new FaultyImplementationError("Unknown buffer type: " + String.valueOf(this.forwards.getClass()));
            }
        }
    }

    public static HistoryEntry<BlockOrBiomeBuffer> load(class_2540 friendlyByteBuf) {
        class_2338 origin = friendlyByteBuf.method_10811();
        String description = friendlyByteBuf.method_19772();
        byte modifiers = friendlyByteBuf.readByte();
        int dataVersion = friendlyByteBuf.readInt();
        byte bufferType = friendlyByteBuf.readByte();
        switch (bufferType) {
            case 0: {
                BlockBuffer forwards = BlockBuffer.loadNBT(friendlyByteBuf, dataVersion);
                BlockBuffer backwards = BlockBuffer.loadNBT(friendlyByteBuf, dataVersion);
                return new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, origin, description, modifiers);
            }
            case 1: {
                BiomeBuffer forwards = BiomeBuffer.load(friendlyByteBuf);
                BiomeBuffer backwards = BiomeBuffer.load(friendlyByteBuf);
                return new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, origin, description, modifiers);
            }
        }
        throw new FaultyImplementationError("Unknown buffer type: " + bufferType);
    }

    public boolean hasModifier(int modifier) {
        return (this.modifiers & modifier) != 0;
    }

    private static <T> int calculateBytes(T forwards, T backwards) {
        if (forwards instanceof BlockBuffer) {
            BlockBuffer blockBuffer = (BlockBuffer)forwards;
            return blockBuffer.estimateSizeInRAM() + ((BlockBuffer)backwards).estimateSizeInRAM();
        }
        return 0;
    }
}

