/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties.server;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.packets.AxiomClientboundSetWorldProperty;
import com.moulberry.axiom.world_properties.WorldPropertyDataType;
import com.moulberry.axiom.world_properties.WorldPropertyWidgetType;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ServerWorldProperty<T> {
    private final class_2960 id;
    private final String name;
    private final boolean localizeName;
    private WorldPropertyWidgetType<T> widget;
    private T value;
    private Predicate<T> handler;

    public ServerWorldProperty(class_2960 id, String name, boolean localizeName, WorldPropertyWidgetType<T> widget, T value, Predicate<T> handler) {
        this.id = id;
        this.name = name;
        this.localizeName = localizeName;
        this.widget = widget;
        this.value = value;
        this.handler = handler;
    }

    public class_2960 getId() {
        return this.id;
    }

    public WorldPropertyDataType<T> getType() {
        return this.widget.dataType();
    }

    public void update(class_3218 serverLevel, byte[] data) {
        this.value = this.widget.dataType().deserialize(data);
        if (this.handler.test(this.value)) {
            AxiomClientboundSetWorldProperty packet = new AxiomClientboundSetWorldProperty(this.id, this.widget.dataType().getTypeId(), this.widget.dataType().serialize(this.value));
            for (class_3222 player : serverLevel.method_18456()) {
                if (!Axiom.getInstance().hasPermission((class_1657)player)) continue;
                packet.send(player);
            }
        }
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_10812(this.id);
        friendlyByteBuf.method_10814(this.name);
        friendlyByteBuf.writeBoolean(this.localizeName);
        this.widget.write(friendlyByteBuf);
        friendlyByteBuf.method_10813(this.widget.dataType().serialize(this.value));
    }
}

