/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_dweller;

import com.mojang.logging.LogUtils;
import de.cadentem.cave_dweller.config.ServerConfig;
import de.cadentem.cave_dweller.entities.CaveDwellerEntity;
import de.cadentem.cave_dweller.registry.ModEntityTypes;
import de.cadentem.cave_dweller.registry.ModItems;
import de.cadentem.cave_dweller.registry.ModSounds;
import de.cadentem.cave_dweller.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3562;
import net.minecraft.class_5132;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import software.bernie.geckolib.GeckoLib;

public class CaveDweller
implements ModInitializer {
    public static final String MODID = "cave_dweller";
    public static final Logger LOG = LogUtils.getLogger();
    public static boolean doReload;
    private final List<class_1657> spelunkers = new ArrayList<class_1657>();
    private final Random random = new Random();
    private int calmTimer;
    private int noiseTimer;

    public void serverTick(MinecraftServer server) {
        class_3218 overworld;
        if (doReload) {
            this.spelunkers.clear();
            this.resetNoiseTimer();
            this.resetCalmTimer();
            doReload = false;
            LOG.info("Values have been reloaded");
        }
        if ((overworld = server.method_3847(class_1937.field_25179)) == null) {
            return;
        }
        Iterable entities = overworld.method_27909();
        AtomicBoolean dwellerExists = new AtomicBoolean(false);
        entities.forEach(entity -> {
            if (entity instanceof CaveDwellerEntity) {
                dwellerExists.set(true);
                this.resetCalmTimer();
            }
        });
        --this.noiseTimer;
        if (this.noiseTimer <= 0 && (dwellerExists.get() || this.calmTimer <= Utils.secondsToTicks(ServerConfig.RESET_CALM_MAX) / 2)) {
            overworld.method_18766(this::playCaveSoundToSpelunkers);
            this.resetNoiseTimer();
        }
        boolean canSpawn = this.calmTimer <= 0;
        --this.calmTimer;
        if (canSpawn && !dwellerExists.get() && this.random.nextDouble() <= ServerConfig.SPAWN_CHANCE_PER_TICK) {
            this.spelunkers.clear();
            overworld.method_18766(this::listSpelunkers);
            if (!this.spelunkers.isEmpty()) {
                class_1657 victim = this.spelunkers.get(this.random.nextInt(this.spelunkers.size()));
                overworld.method_18766(this::playCaveSoundToSpelunkers);
                CaveDwellerEntity caveDweller = new CaveDwellerEntity(ModEntityTypes.CAVE_DWELLER, (class_1937)overworld);
                caveDweller.method_5648(true);
                caveDweller.method_33574(caveDweller.generatePos((class_1297)victim));
                overworld.method_8649((class_1297)caveDweller);
                this.resetCalmTimer();
                this.resetNoiseTimer();
            }
        }
    }

    private boolean listSpelunkers(class_3222 player) {
        if (this.isPlayerSpelunker(player)) {
            this.spelunkers.add((class_1657)player);
        }
        return true;
    }

    public boolean playCaveSoundToSpelunkers(class_3222 player) {
        if (!this.isPlayerSpelunker(player)) {
            return false;
        }
        class_3414 soundEvent = switch (this.random.nextInt(4)) {
            case 1 -> ModSounds.CAVENOISE_2;
            case 2 -> ModSounds.CAVENOISE_3;
            case 3 -> ModSounds.CAVENOISE_4;
            default -> ModSounds.CAVENOISE_1;
        };
        player.method_5783(soundEvent, 2.0f, 1.0f);
        return true;
    }

    public boolean isPlayerSpelunker(class_3222 player) {
        if (!Utils.isValidPlayer((class_1297)player)) {
            return false;
        }
        if (player.method_19538().field_1351 > (double)ServerConfig.SPAWN_HEIGHT) {
            return false;
        }
        class_3218 serverLevel = player.method_51469();
        int skyLightLevel = serverLevel.method_8314(class_1944.field_9284, player.method_24515()) - serverLevel.method_8594();
        float sunAngle = serverLevel.method_8442(1.0f);
        if (skyLightLevel > 0) {
            float f1 = sunAngle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            sunAngle += (f1 - sunAngle) * 0.2f;
            skyLightLevel = Math.round((float)skyLightLevel * class_3532.method_15362((float)sunAngle));
        }
        if ((skyLightLevel = class_3532.method_15340((int)skyLightLevel, (int)0, (int)15)) > ServerConfig.SKY_LIGHT_LEVEL) {
            return false;
        }
        class_3562 blockLighting = player.method_37908().method_22336().method_15562(class_1944.field_9282);
        if (blockLighting.method_15543(player.method_24515()) > ServerConfig.BLOCK_LIGHT_LEVEL) {
            return false;
        }
        return ServerConfig.ALLOW_SURFACE_SPAWN || !player.method_37908().method_8311(player.method_24515());
    }

    private void resetCalmTimer() {
        if (this.random.nextDouble() <= ServerConfig.RESET_CALM_COOLDOWN_CHANCE) {
            this.calmTimer = Utils.secondsToTicks(ServerConfig.RESET_CALM_COOLDOWN);
        } else {
            int max = ServerConfig.RESET_CALM_MAX;
            int min = ServerConfig.RESET_CALM_MIN;
            if (max < min) {
                int temp = min;
                min = max;
                max = temp;
                LOG.error("Configuration for `RESET_CALM` was wrong - max [{}] was smaller than min [{}] - values have been switched to prevent a crash", (Object)max, (Object)min);
            }
            this.calmTimer = this.random.nextInt(Utils.secondsToTicks(min), Utils.secondsToTicks(max + 1));
        }
    }

    private void resetNoiseTimer() {
        int max = ServerConfig.RESET_NOISE_MAX;
        int min = ServerConfig.RESET_NOISE_MIN;
        if (max < min) {
            int temp = min;
            min = max;
            max = temp;
            LOG.error("Configuration for `RESET_NOISE` was wrong - max [{}] was smaller than min [{}] - values have been switched to prevent a crash", (Object)max, (Object)min);
        }
        this.noiseTimer = this.random.nextInt(Utils.secondsToTicks(min), Utils.secondsToTicks(max + 1));
    }

    public void onInitialize() {
        GeckoLib.initialize();
        ServerTickEvents.START_SERVER_TICK.register(this::serverTick);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ServerConfig.load());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            doReload = true;
        });
        ModItems.register();
        ModSounds.init();
        ModEntityTypes.register();
        FabricDefaultAttributeRegistry.register(ModEntityTypes.CAVE_DWELLER, (class_5132)CaveDwellerEntity.getAttributeBuilder());
    }
}

