/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_dweller.entities;

import de.cadentem.cave_dweller.config.ServerConfig;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerBreakDoorGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerBreakInvisGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerChaseGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerFleeGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerStareGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerStrollGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerTargetSeesMeGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerTargetTooCloseGoal;
import de.cadentem.cave_dweller.entities.goals.Roll;
import de.cadentem.cave_dweller.registry.ModSounds;
import de.cadentem.cave_dweller.util.Utils;
import java.util.List;
import java.util.Random;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1410;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CaveDwellerEntity
extends class_1588
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation OLD_RUN = RawAnimation.begin().then("animation.cave_dweller.run", Animation.LoopType.LOOP);
    private final RawAnimation IDLE = RawAnimation.begin().then("animation.cave_dweller.idle", Animation.LoopType.LOOP);
    private final RawAnimation CHASE = RawAnimation.begin().then("animation.cave_dweller.new_run", Animation.LoopType.LOOP);
    private final RawAnimation CHASE_IDLE = RawAnimation.begin().then("animation.cave_dweller.run_idle", Animation.LoopType.LOOP);
    private final RawAnimation CROUCH_RUN = RawAnimation.begin().then("animation.cave_dweller.crouch_run_new", Animation.LoopType.LOOP);
    private final RawAnimation CROUCH_IDLE = RawAnimation.begin().then("animation.cave_dweller.crouch_idle", Animation.LoopType.LOOP);
    private final RawAnimation CALM_RUN = RawAnimation.begin().then("animation.cave_dweller.calm_move", Animation.LoopType.LOOP);
    private final RawAnimation CALM_STILL = RawAnimation.begin().then("animation.cave_dweller.calm_idle", Animation.LoopType.LOOP);
    private final RawAnimation IS_SPOTTED = RawAnimation.begin().then("animation.cave_dweller.spotted", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private final RawAnimation CRAWL = RawAnimation.begin().then("animation.cave_dweller.crawl", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private final RawAnimation FLEE = RawAnimation.begin().then("animation.cave_dweller.flee", Animation.LoopType.LOOP);
    public static final class_2940<Boolean> FLEEING_ACCESSOR = class_2945.method_12791(CaveDwellerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> CROUCHING_ACCESSOR = class_2945.method_12791(CaveDwellerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> AGGRO_ACCESSOR = class_2945.method_12791(CaveDwellerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SQUEEZING_ACCESSOR = class_2945.method_12791(CaveDwellerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SPOTTED_ACCESSOR = class_2945.method_12791(CaveDwellerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> CLIMBING_ACCESSOR = class_2945.method_12791(CaveDwellerEntity.class, (class_2941)class_2943.field_13323);
    private final float twoBlockSpaceCooldown;
    public Roll currentRoll = Roll.STROLL;
    public boolean fakeSize;
    public boolean isFleeing;
    public boolean spottedByPlayer;
    public boolean squeezeCrawling;
    public boolean pleaseStopMoving;
    private float twoBlockSpaceTimer;
    private int ticksTillRemove;
    private int chaseSoundClock;
    private boolean inTwoBlockSpace;
    private boolean alreadyPlayedFleeSound;
    private boolean alreadyPlayedSpottedSound;
    private boolean startedPlayingChaseSound;
    private boolean alreadyPlayedDeathSound;

    public CaveDwellerEntity(class_1299<? extends CaveDwellerEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.method_18382();
        this.twoBlockSpaceCooldown = 5.0f;
        this.ticksTillRemove = Utils.secondsToTicks(ServerConfig.TIME_UNTIL_LEAVE);
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 tagData) {
        this.setAttribute(this.method_5996(class_5134.field_23716), ServerConfig.MAX_HEALTH);
        this.setAttribute(this.method_5996(class_5134.field_23721), ServerConfig.ATTACK_DAMAGE);
        this.setAttribute(this.method_5996(class_5134.field_23723), ServerConfig.ATTACK_SPEED);
        this.setAttribute(this.method_5996(class_5134.field_23719), ServerConfig.MOVEMENT_SPEED);
        return super.method_5943(level, difficulty, reason, spawnData, tagData);
    }

    private void setAttribute(class_1324 attribute, double value) {
        if (attribute != null) {
            attribute.method_6192(value);
            if (attribute.method_6198() == class_5134.field_23716) {
                this.method_6033((float)value);
            } else if (attribute.method_6198() == class_5134.field_23719) {
                this.method_6125((float)value);
            }
        }
    }

    public static class_5132 getAttributeBuilder() {
        double maxHealth = 60.0;
        double attackDamage = 6.0;
        double attackSpeed = 0.35;
        double movementSpeed = 0.5;
        double followRange = 100.0;
        return CaveDwellerEntity.method_26828().method_26868(class_5134.field_23716, maxHealth).method_26868(class_5134.field_23721, attackDamage).method_26868(class_5134.field_23723, attackSpeed).method_26868(class_5134.field_23719, movementSpeed).method_26868(class_5134.field_23717, followRange).method_26866();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLEEING_ACCESSOR, (Object)false);
        this.field_6011.method_12784(CROUCHING_ACCESSOR, (Object)false);
        this.field_6011.method_12784(AGGRO_ACCESSOR, (Object)false);
        this.field_6011.method_12784(SQUEEZING_ACCESSOR, (Object)false);
        this.field_6011.method_12784(SPOTTED_ACCESSOR, (Object)false);
        this.field_6011.method_12784(CLIMBING_ACCESSOR, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new CaveDwellerChaseGoal(this, 0.85f, true, 20.0f));
        this.field_6201.method_6277(1, (class_1352)new CaveDwellerFleeGoal(this, 20.0f, 1.0));
        this.field_6201.method_6277(2, (class_1352)new CaveDwellerBreakInvisGoal(this));
        this.field_6201.method_6277(2, (class_1352)new CaveDwellerStareGoal(this));
        if (ServerConfig.CAN_BREAK_DOOR) {
            this.field_6201.method_6277(2, (class_1352)new CaveDwellerBreakDoorGoal((class_1308)this, difficulty -> true));
        }
        this.field_6201.method_6277(3, (class_1352)new CaveDwellerStrollGoal(this, 0.7));
        this.field_6185.method_6277(1, (class_1352)new CaveDwellerTargetTooCloseGoal(this, 12.0f));
        this.field_6185.method_6277(2, (class_1352)new CaveDwellerTargetSeesMeGoal(this));
    }

    public class_243 generatePos(class_1297 player) {
        class_243 playerPos = player.method_19538();
        Random rand = new Random();
        double randX = rand.nextInt(70) - 35;
        double randZ = rand.nextInt(70) - 35;
        int posX = (int)(playerPos.field_1352 + randX);
        int posY = (int)(playerPos.field_1351 + 10.0);
        int posZ = (int)(playerPos.field_1350 + randZ);
        int runFor = 100;
        while (runFor >= 0) {
            class_2338 blockPosition = new class_2338(posX, posY, posZ);
            class_2338 blockPosition2 = new class_2338(posX, posY + 1, posZ);
            class_2338 blockPosition3 = new class_2338(posX, posY + 2, posZ);
            class_2338 blockPosition4 = new class_2338(posX, posY - 1, posZ);
            --runFor;
            if (!this.method_37908().method_8320(blockPosition).method_51366() && !this.method_37908().method_8320(blockPosition2).method_51366() && !this.method_37908().method_8320(blockPosition3).method_51366() && this.method_37908().method_8320(blockPosition4).method_51366()) break;
            --posY;
        }
        return new class_243((double)posX, (double)posY, (double)posZ);
    }

    protected boolean method_5860(@NotNull class_1297 vehicle) {
        if (ServerConfig.ALLOW_RIDING) {
            return super.method_5860(vehicle);
        }
        return false;
    }

    public boolean method_5873(@NotNull class_1297 vehicle, boolean force) {
        if (ServerConfig.ALLOW_RIDING) {
            return super.method_5873(vehicle, force);
        }
        return false;
    }

    public void method_5773() {
        --this.ticksTillRemove;
        if (this.ticksTillRemove <= 0) {
            this.playDisappearSound();
            this.method_31472();
        }
        if (this.field_6201.method_35115().isEmpty()) {
            this.method_5959();
            this.field_6201.method_6275();
        }
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339(this.method_19538().field_1352, this.method_19538().field_1351 + 2.0, this.method_19538().field_1350);
        class_2680 above = this.method_37908().method_8320((class_2338)blockpos$mutableblockpos);
        boolean blocksMotion = above.method_51366();
        if (blocksMotion) {
            this.twoBlockSpaceTimer = this.twoBlockSpaceCooldown;
            this.inTwoBlockSpace = true;
        } else {
            this.twoBlockSpaceTimer -= 1.0f;
            if (this.twoBlockSpaceTimer <= 0.0f) {
                this.inTwoBlockSpace = false;
            }
        }
        if (this.method_6510() || this.isFleeing) {
            this.spottedByPlayer = false;
            this.field_6011.method_12778(SPOTTED_ACCESSOR, (Object)false);
        }
        super.method_5773();
        this.field_6011.method_12778(CROUCHING_ACCESSOR, (Object)this.inTwoBlockSpace);
        if (((Boolean)this.field_6011.method_12789(SPOTTED_ACCESSOR)).booleanValue()) {
            this.playSpottedSound();
        }
        if (!this.method_37908().field_9236) {
            this.setClimbing(this.field_5976);
        }
        if (this.method_5968() == null) {
            this.method_5980((class_1309)this.method_37908().method_8604(this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, 128.0, Utils::isValidPlayer));
        }
    }

    @NotNull
    public class_4048 method_18377(@NotNull class_4050 pose) {
        return this.fakeSize ? new class_4048(0.5f, 0.9f, true) : new class_4048(0.5f, 1.9f, true);
    }

    private boolean isMoving() {
        class_243 velocity = this.method_18798();
        float avgVelocity = (float)(Math.abs(velocity.field_1352) + Math.abs(velocity.field_1350)) / 2.0f;
        return avgVelocity > 0.03f;
    }

    public void reRoll() {
        this.currentRoll = Roll.fromValue(new Random().nextInt(3));
    }

    public void pickRoll(@NotNull List<Roll> rolls) {
        this.currentRoll = rolls.get(new Random().nextInt(rolls.size()));
    }

    public class_11 createShortPath(class_1309 target) {
        this.fakeSize = true;
        this.method_18382();
        class_11 shortPath = this.method_5942().method_6349((class_1297)target, 0);
        this.fakeSize = false;
        this.method_18382();
        return shortPath;
    }

    public class_11 createShortPath(@NotNull class_243 position) {
        this.fakeSize = true;
        this.method_18382();
        class_11 shortPath = this.method_5942().method_6352(position.field_1352, position.field_1351, position.field_1350, 0);
        this.fakeSize = false;
        this.method_18382();
        return shortPath;
    }

    public boolean method_6101() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        if (!ServerConfig.CAN_CLIMB) {
            return false;
        }
        if (this.method_5968() != null && this.method_5968().method_30950((float)1.0f).field_1351 > this.method_23318()) {
            return (Boolean)this.field_6011.method_12789(CLIMBING_ACCESSOR);
        }
        return false;
    }

    public void setClimbing(boolean isClimbing) {
        this.field_6011.method_12778(CLIMBING_ACCESSOR, (Object)isClimbing);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new class_1410((class_1308)this, level);
    }

    private PlayState predicate(AnimationState<CaveDwellerEntity> state) {
        if (((Boolean)this.field_6011.method_12789(AGGRO_ACCESSOR)).booleanValue()) {
            if (((Boolean)this.field_6011.method_12789(SQUEEZING_ACCESSOR)).booleanValue()) {
                return state.setAndContinue(this.CRAWL);
            }
            if (((Boolean)this.field_6011.method_12789(CROUCHING_ACCESSOR)).booleanValue()) {
                if (state.isMoving()) {
                    return state.setAndContinue(this.CROUCH_RUN);
                }
                return state.setAndContinue(this.CROUCH_IDLE);
            }
            if (state.isMoving()) {
                return state.setAndContinue(this.CHASE);
            }
            return state.setAndContinue(this.CHASE_IDLE);
        }
        if (((Boolean)this.field_6011.method_12789(FLEEING_ACCESSOR)).booleanValue()) {
            if (state.isMoving()) {
                return state.setAndContinue(this.FLEE);
            }
            return state.setAndContinue(this.CHASE_IDLE);
        }
        if (((Boolean)this.field_6011.method_12789(SPOTTED_ACCESSOR)).booleanValue() && !state.isMoving()) {
            return state.setAndContinue(this.IS_SPOTTED);
        }
        if (state.isMoving()) {
            return state.setAndContinue(this.CALM_RUN);
        }
        return state.setAndContinue(this.CALM_STILL);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 3, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void method_5712(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        super.method_5712(pPos, pState);
        this.playEntitySound(this.chooseStep());
    }

    private void playEntitySound(class_3414 soundEvent) {
        this.playEntitySound(soundEvent, 1.0f, 1.0f);
    }

    private void playEntitySound(class_3414 soundEvent, float volume, float pitch) {
        this.method_37908().method_43129(null, (class_1297)this, soundEvent, class_3419.field_15251, volume, pitch);
    }

    private void playBlockPosSound(class_3414 soundEvent, float volume, float pitch) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            int radiusSq = 3600;
            serverLevel.method_18766(player -> player.method_5858((class_1297)this) <= (double)radiusSq).forEach(player -> player.method_5783(soundEvent, volume, pitch));
        }
    }

    public void playChaseSound() {
        if (this.startedPlayingChaseSound || this.isMoving()) {
            if (this.chaseSoundClock <= 0) {
                Random rand = new Random();
                switch (rand.nextInt(4)) {
                    case 0: {
                        this.playEntitySound(ModSounds.CHASE_1, 3.0f, 1.0f);
                        break;
                    }
                    case 1: {
                        this.playEntitySound(ModSounds.CHASE_2, 3.0f, 1.0f);
                        break;
                    }
                    case 2: {
                        this.playEntitySound(ModSounds.CHASE_3, 3.0f, 1.0f);
                        break;
                    }
                    case 3: {
                        this.playEntitySound(ModSounds.CHASE_4, 3.0f, 1.0f);
                    }
                }
                this.startedPlayingChaseSound = true;
                this.resetChaseSoundClock();
            }
            --this.chaseSoundClock;
        }
    }

    public void playDisappearSound() {
        this.playBlockPosSound(ModSounds.DISAPPEAR, 3.0f, 1.0f);
    }

    public void playFleeSound() {
        if (!this.alreadyPlayedFleeSound) {
            Random rand = new Random();
            switch (rand.nextInt(2)) {
                case 0: {
                    this.playEntitySound(ModSounds.FLEE_1, 3.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.playEntitySound(ModSounds.FLEE_2, 3.0f, 1.0f);
                }
            }
            this.alreadyPlayedFleeSound = true;
        }
    }

    private void playSpottedSound() {
        if (!this.alreadyPlayedSpottedSound) {
            this.playEntitySound(ModSounds.SPOTTED, 3.0f, 1.0f);
            this.alreadyPlayedSpottedSound = true;
        }
    }

    private void resetChaseSoundClock() {
        this.chaseSoundClock = Utils.secondsToTicks(5);
    }

    private class_3414 chooseStep() {
        Random rand = new Random();
        return switch (rand.nextInt(4)) {
            case 1 -> ModSounds.CHASE_STEP_2;
            case 2 -> ModSounds.CHASE_STEP_3;
            case 3 -> ModSounds.CHASE_STEP_4;
            default -> ModSounds.CHASE_STEP_1;
        };
    }

    private class_3414 chooseHurtSound() {
        Random rand = new Random();
        return switch (rand.nextInt(4)) {
            case 1 -> ModSounds.DWELLER_HURT_2;
            case 2 -> ModSounds.DWELLER_HURT_3;
            case 3 -> ModSounds.DWELLER_HURT_4;
            default -> ModSounds.DWELLER_HURT_1;
        };
    }

    protected void method_6013(@NotNull class_1282 pSource) {
        class_3414 soundevent = this.chooseHurtSound();
        this.playEntitySound(soundevent, 2.0f, 1.0f);
    }

    protected void method_6108() {
        super.method_6108();
        if (!this.alreadyPlayedDeathSound) {
            this.playBlockPosSound(ModSounds.DWELLER_DEATH, 2.0f, 1.0f);
            this.alreadyPlayedDeathSound = true;
        }
    }

    public boolean isLookingAtMe(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)entity;
        if (player.method_7325() || !player.method_5805()) {
            return false;
        }
        if (player.method_5836(1.0f).method_1022(this.method_30950(1.0f)) > (double)ServerConfig.SPOTTING_RANGE) {
            return false;
        }
        return this.isLooking((class_1309)player);
    }

    public boolean isTargetNotLooking() {
        class_1309 target = this.method_5968();
        if (target == null) {
            return false;
        }
        return !this.isLooking(target);
    }

    private boolean isLooking(class_1309 target) {
        class_243 viewVector = target.method_5828(1.0f).method_1029();
        class_243 difference = new class_243(this.method_23317() - target.method_23317(), this.method_23320() - target.method_23320(), this.method_23321() - target.method_23321());
        double dot = viewVector.method_1026(difference = difference.method_1029());
        return dot > 0.0 && target.method_6057((class_1297)this);
    }

    private void teleport() {
        class_1309 target = this.method_5968();
        if (target == null) {
            return;
        }
        class_243 targetPosition = new class_243(this.method_23317() - target.method_23317(), this.method_23323(0.5) - target.method_23320(), this.method_23321() - target.method_23321());
        targetPosition = targetPosition.method_1029();
        double radius = 32.0;
        double d1 = this.method_23317() + (this.method_6051().method_43058() - 0.5) * (radius / 2.0) - targetPosition.field_1352 * radius;
        double d2 = this.method_23318() + ((double)this.method_6051().method_43048((int)radius) - radius / 2.0) - targetPosition.field_1351 * radius;
        double d3 = this.method_23321() + (this.method_6051().method_43058() - 0.5) * (radius / 2.0) - targetPosition.field_1350 * radius;
        class_2338.class_2339 validPosition = new class_2338.class_2339(d1, d2, d3);
        while (validPosition.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)validPosition).method_51366()) {
            validPosition.method_10098(class_2350.field_11033);
        }
        this.method_5859(validPosition.method_10263(), validPosition.method_10264(), validPosition.method_10260());
    }

    public boolean inTargetLineOfSight() {
        return this.method_5968() != null && this.method_5968().method_6057((class_1297)this);
    }

    public boolean inLineOfSight(class_1309 target) {
        return target != null && target.method_6057((class_1297)this);
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSourceIn) {
        return this.chooseHurtSound();
    }

    protected class_3414 method_6002() {
        return ModSounds.DWELLER_DEATH;
    }

    protected float method_6107() {
        return 0.4f;
    }
}

