/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.transfer;

import com.simibubi.create.AllPackets;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.fluids.transfer.FluidSplashPacket;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.mixin.fabric.SortedArraySetAccessor;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4706;
import org.jetbrains.annotations.Nullable;

public abstract class FluidManipulationBehaviour
extends BlockEntityBehaviour {
    class_3341 affectedArea;
    class_2338 rootPos;
    boolean infinite;
    protected boolean counterpartActed;
    static final int searchedPerTick = 1024;
    static final int validationTimerMin = 160;
    List<BlockPosEntry> frontier;
    Set<class_2338> visited;
    int revalidateIn;

    public FluidManipulationBehaviour(SmartBlockEntity be) {
        super(be);
        this.setValidationTimer();
        this.infinite = false;
        this.visited = new HashSet<class_2338>();
        this.frontier = new ArrayList<BlockPosEntry>();
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void counterpartActed(TransactionContext ctx) {
        this.snapshotParticipant().updateSnapshots(ctx);
        this.counterpartActed = true;
    }

    protected abstract SnapshotParticipant<?> snapshotParticipant();

    protected int validationTimer() {
        int maxBlocks = this.maxBlocks();
        return maxBlocks < 0 ? 160 : Math.max(160, maxBlocks / 1024 + 1);
    }

    protected int setValidationTimer() {
        this.revalidateIn = this.validationTimer();
        return this.revalidateIn;
    }

    protected int setLongValidationTimer() {
        this.revalidateIn = this.validationTimer() * 2;
        return this.revalidateIn;
    }

    protected int maxRange() {
        return (Integer)AllConfigs.server().fluids.hosePulleyRange.get();
    }

    protected int maxBlocks() {
        return (Integer)AllConfigs.server().fluids.hosePulleyBlockThreshold.get();
    }

    protected boolean fillInfinite() {
        return (Boolean)AllConfigs.server().fluids.fillInfinite.get();
    }

    public void reset(@Nullable TransactionContext ctx) {
        if (this.affectedArea != null) {
            this.scheduleUpdatesInAffectedArea();
        }
        this.affectedArea = null;
        this.setValidationTimer();
        this.frontier.clear();
        this.visited.clear();
        this.infinite = false;
    }

    @Override
    public void destroy() {
        this.reset(null);
        super.destroy();
    }

    protected void scheduleUpdatesInAffectedArea() {
        class_1937 world = this.getWorld();
        class_2338.method_20437((class_2338)new class_2338(this.affectedArea.method_35415() - 1, this.affectedArea.method_35416() - 1, this.affectedArea.method_35417() - 1), (class_2338)new class_2338(this.affectedArea.method_35418() + 1, this.affectedArea.method_35419() + 1, this.affectedArea.method_35420() + 1)).forEach(pos -> {
            class_3610 nextFluidState = world.method_8316(pos);
            if (nextFluidState.method_15769()) {
                return;
            }
            world.method_39281(pos, nextFluidState.method_15772(), world.method_8409().method_43048(5));
        });
    }

    protected int comparePositions(BlockPosEntry e1, BlockPosEntry e2) {
        class_243 centerOfRoot = VecHelper.getCenterOf((class_2382)this.rootPos);
        class_2338 pos2 = e2.pos;
        class_2338 pos1 = e1.pos;
        if (pos1.method_10264() != pos2.method_10264()) {
            return Integer.compare(pos2.method_10264(), pos1.method_10264());
        }
        int compareDistance = Integer.compare(e2.distance, e1.distance);
        if (compareDistance != 0) {
            return compareDistance;
        }
        int distanceCompared = Double.compare(VecHelper.getCenterOf((class_2382)pos2).method_1025(centerOfRoot), VecHelper.getCenterOf((class_2382)pos1).method_1025(centerOfRoot));
        if (distanceCompared != 0) {
            return distanceCompared;
        }
        int xCompared = Integer.compare(pos2.method_10263(), pos1.method_10263());
        if (xCompared != 0) {
            return xCompared;
        }
        return Integer.compare(pos2.method_10260(), pos1.method_10260());
    }

    protected class_3611 search(class_3611 fluid, List<BlockPosEntry> frontier, Set<class_2338> visited, BiConsumer<class_2338, Integer> add, boolean searchDownward) throws ChunkNotLoadedException {
        class_1937 world = this.getWorld();
        int maxBlocks = this.maxBlocks();
        int maxRange = this.maxRange();
        int maxRangeSq = maxRange * maxRange;
        for (int i = 0; !(i >= 1024 || frontier.isEmpty() || visited.size() > maxBlocks && this.canDrainInfinitely(fluid)); ++i) {
            BlockPosEntry entry = frontier.remove(0);
            class_2338 currentPos = entry.pos;
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            if (!world.method_8477(currentPos)) {
                throw new ChunkNotLoadedException();
            }
            class_3610 fluidState = world.method_8316(currentPos);
            if (fluidState.method_15769()) continue;
            class_3611 currentFluid = FluidHelper.convertToStill(fluidState.method_15772());
            if (fluid == null) {
                fluid = currentFluid;
            }
            if (!currentFluid.method_15780(fluid)) continue;
            add.accept(currentPos, entry.distance);
            for (class_2350 side : Iterate.directions) {
                class_3611 nextFluid;
                class_3610 nextFluidState;
                if (!searchDownward && side == class_2350.field_11033) continue;
                class_2338 offsetPos = currentPos.method_10093(side);
                if (!world.method_8477(offsetPos)) {
                    throw new ChunkNotLoadedException();
                }
                if (visited.contains(offsetPos) || offsetPos.method_10262((class_2382)this.rootPos) > (double)maxRangeSq || (nextFluidState = world.method_8316(offsetPos)).method_15769() || (nextFluid = nextFluidState.method_15772()) == FluidHelper.convertToFlowing(nextFluid) && side == class_2350.field_11036 && !VecHelper.onSameAxis(this.rootPos, offsetPos, class_2350.class_2351.field_11052)) continue;
                frontier.add(new BlockPosEntry(offsetPos, entry.distance + 1));
            }
        }
        return fluid;
    }

    protected void playEffect(class_1937 world, class_2338 pos, class_3611 fluid, boolean fillSound) {
        if (fluid == null) {
            return;
        }
        class_2338 splooshPos = pos == null ? this.blockEntity.method_11016() : pos;
        FluidStack stack = new FluidStack(fluid, 1L);
        FluidVariant variant = FluidVariant.of((class_3611)fluid);
        class_3414 soundevent = fillSound ? FluidVariantAttributes.getFillSound((FluidVariant)variant) : FluidVariantAttributes.getEmptySound((FluidVariant)variant);
        world.method_8396(null, splooshPos, soundevent, class_3419.field_15245, 0.3f, 1.0f);
        if (world instanceof class_3218) {
            AllPackets.sendToNear(world, splooshPos, 10, new FluidSplashPacket(splooshPos, stack));
        }
    }

    protected boolean canDrainInfinitely(class_3611 fluid) {
        if (fluid == null) {
            return false;
        }
        return this.maxBlocks() != -1 && ((BottomlessFluidMode)AllConfigs.server().fluids.bottomlessFluidMode.get()).test(fluid);
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        if (this.infinite) {
            NBTHelper.putMarker(nbt, "Infinite");
        }
        if (this.rootPos != null) {
            nbt.method_10566("LastPos", (class_2520)class_2512.method_10692((class_2338)this.rootPos));
        }
        if (this.affectedArea != null) {
            nbt.method_10566("AffectedAreaFrom", (class_2520)class_2512.method_10692((class_2338)new class_2338(this.affectedArea.method_35415(), this.affectedArea.method_35416(), this.affectedArea.method_35417())));
            nbt.method_10566("AffectedAreaTo", (class_2520)class_2512.method_10692((class_2338)new class_2338(this.affectedArea.method_35418(), this.affectedArea.method_35419(), this.affectedArea.method_35420())));
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        this.infinite = nbt.method_10545("Infinite");
        if (nbt.method_10545("LastPos")) {
            this.rootPos = class_2512.method_10691((class_2487)nbt.method_10562("LastPos"));
        }
        if (nbt.method_10545("AffectedAreaFrom") && nbt.method_10545("AffectedAreaTo")) {
            this.affectedArea = class_3341.method_34390((class_2382)class_2512.method_10691((class_2487)nbt.method_10562("AffectedAreaFrom")), (class_2382)class_2512.method_10691((class_2487)nbt.method_10562("AffectedAreaTo")));
        }
        super.read(nbt, clientPacket);
    }

    public static <T> class_4706<T> copySet(class_4706<T> set) {
        int size = set.size();
        SortedArraySetAccessor access = (SortedArraySetAccessor)set;
        Comparator comparator = access.create$getComparator();
        T[] contents = access.create$getContents();
        Object[] copiedContents = new Object[size];
        System.arraycopy(contents, 0, copiedContents, 0, size);
        class_4706 copy = class_4706.method_34960(comparator, (int)size);
        SortedArraySetAccessor copyAccess = (SortedArraySetAccessor)copy;
        copyAccess.create$setContents(copiedContents);
        copyAccess.create$setSize(size);
        return copy;
    }

    public static <T> void dequeue(class_4706<T> set) {
        ((SortedArraySetAccessor)set).create$callRemoveInternal(0);
    }

    public record BlockPosEntry(class_2338 pos, int distance) {
    }

    public static class ChunkNotLoadedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static enum BottomlessFluidMode implements Predicate<class_3611>
    {
        ALLOW_ALL(fluid -> true),
        DENY_ALL(fluid -> false),
        ALLOW_BY_TAG(fluid -> AllTags.AllFluidTags.BOTTOMLESS_ALLOW.matches((class_3611)fluid)),
        DENY_BY_TAG(fluid -> !AllTags.AllFluidTags.BOTTOMLESS_DENY.matches((class_3611)fluid));

        private final Predicate<class_3611> predicate;

        private BottomlessFluidMode(Predicate<class_3611> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(class_3611 fluid) {
            return this.predicate.test(fluid);
        }
    }
}

