/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public final class NBTProcessors {
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> processors = new HashMap();
    private static final Map<class_2591<?>, UnaryOperator<class_2487>> survivalProcessors = new HashMap();
    private static final UnaryOperator<class_2487> signProcessor;

    public static synchronized void addProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(class_2591<?> type, UnaryOperator<class_2487> processor) {
        survivalProcessors.put(type, processor);
    }

    public static UnaryOperator<class_2487> itemProcessor(String tagKey) {
        return data -> {
            class_2487 compound = data.method_10562(tagKey);
            if (!compound.method_10573("tag", 10)) {
                return data;
            }
            class_2487 itemTag = compound.method_10562("tag");
            if (itemTag == null) {
                return data;
            }
            HashSet keys = new HashSet(itemTag.method_10541());
            for (String key : keys) {
                if (!NBTProcessors.isUnsafeItemNBTKey(key)) continue;
                itemTag.method_10551(key);
            }
            if (itemTag.method_33133()) {
                compound.method_10551("tag");
            }
            return data;
        };
    }

    public static class_1799 withUnsafeNBTDiscarded(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return stack;
        }
        class_1799 copy = stack.method_7972();
        copy.method_7980(NBTProcessors.withUnsafeNBTDiscarded(tag));
        return copy;
    }

    public static class_2487 withUnsafeNBTDiscarded(class_2487 tag) {
        if (tag == null) {
            return null;
        }
        class_2487 copy = tag.method_10553();
        tag.method_10541().stream().filter(NBTProcessors::isUnsafeItemNBTKey).forEach(arg_0 -> ((class_2487)copy).method_10551(arg_0));
        return copy;
    }

    public static boolean isUnsafeItemNBTKey(String name) {
        if (name.equals("StoredEnchantments")) {
            return false;
        }
        if (name.equals("Enchantments")) {
            return false;
        }
        if (name.contains("Potion")) {
            return false;
        }
        if (name.contains("Damage")) {
            return false;
        }
        return !name.equals("display");
    }

    public static boolean textComponentHasClickEvent(String json) {
        return NBTProcessors.textComponentHasClickEvent((class_2561)class_2561.class_2562.method_10877((String)(json.isEmpty() ? "\"\"" : json)));
    }

    public static boolean textComponentHasClickEvent(class_2561 component) {
        for (class_2561 sibling : component.method_10855()) {
            if (!NBTProcessors.textComponentHasClickEvent(sibling)) continue;
            return true;
        }
        return component != null && component.method_10866() != null && component.method_10866().method_10970() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static class_2487 process(class_2680 blockState, class_2586 blockEntity, class_2487 compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        class_2591 type = blockEntity.method_11017();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (class_2487)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (class_2487)processors.get(type).apply(compound);
        }
        if (blockEntity instanceof class_2636) {
            return compound;
        }
        if (blockState.method_26164(class_3481.field_41282)) {
            return (class_2487)signProcessor.apply(compound);
        }
        if (blockEntity.method_11011()) {
            return null;
        }
        return compound;
    }

    static {
        NBTProcessors.addProcessor(class_2591.field_16412, data -> {
            if (!data.method_10573("Book", 10)) {
                return data;
            }
            class_2487 book = data.method_10562("Book");
            if (!book.method_10573("tag", 10)) {
                return data;
            }
            class_2487 tag = book.method_10562("tag");
            if (!tag.method_10573("pages", 9)) {
                return data;
            }
            class_2499 pages = tag.method_10554("pages", 8);
            for (class_2520 inbt : pages) {
                if (!NBTProcessors.textComponentHasClickEvent(inbt.method_10714())) continue;
                return null;
            }
            return data;
        });
        NBTProcessors.addProcessor((class_2591)AllBlockEntityTypes.CREATIVE_CRATE.get(), NBTProcessors.itemProcessor("Filter"));
        NBTProcessors.addProcessor((class_2591)AllBlockEntityTypes.PLACARD.get(), NBTProcessors.itemProcessor("Item"));
        NBTProcessors.addProcessor((class_2591)AllBlockEntityTypes.CLIPBOARD.get(), data -> {
            if (!data.method_10573("Item", 10)) {
                return data;
            }
            class_2487 book = data.method_10562("Item");
            if (!book.method_10573("tag", 10)) {
                return data;
            }
            class_2487 itemData = book.method_10562("tag");
            for (List entries : NBTHelper.readCompoundList(itemData.method_10554("Pages", 10), pageTag -> NBTHelper.readCompoundList(pageTag.method_10554("Entries", 10), tag -> tag.method_10558("Text")))) {
                for (String entry : entries) {
                    if (!NBTProcessors.textComponentHasClickEvent(entry)) continue;
                    return null;
                }
            }
            return data;
        });
        signProcessor = data -> {
            for (String key : List.of("front_text", "back_text")) {
                class_2487 textTag = data.method_10562(key);
                if (!textTag.method_10573("messages", 9)) continue;
                for (class_2520 tag : textTag.method_10554("messages", 8)) {
                    class_2519 stringTag;
                    if (!(tag instanceof class_2519) || !NBTProcessors.textComponentHasClickEvent((stringTag = (class_2519)tag).method_10714())) continue;
                    return null;
                }
            }
            if (data.method_10545("front_item") || data.method_10545("back_item")) {
                return null;
            }
            return data;
        };
    }
}

